package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.domain.AlsacenterBlockchainResult;
import com.alipay.api.domain.AlsacenterDocusignResult;
import com.alipay.api.domain.AlsacenterMultiCaResult;
import com.alipay.api.domain.AlsacenterPaperSealResult;
import com.alipay.api.domain.AlsacenterPartCaResult;
import com.alipay.api.domain.AlsacenterSingleCaResult;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.boss.prod.alsacenter.sign.query response.
 * 
 * @author auto create
 * @since 1.0, 2023-03-22 19:46:24
 */
public class AlipayBossProdAlsacenterSignQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 6881162563391229164L;

	/** 
	 * 区块链用印结果
	 */
	@ApiField("blockchain_result")
	private AlsacenterBlockchainResult blockchainResult;

	/** 
	 * docusign用印结果
	 */
	@ApiField("docusign_result")
	private AlsacenterDocusignResult docusignResult;

	/** 
	 * 签署受理唯一流水号
	 */
	@ApiField("flow_id")
	private String flowId;

	/** 
	 * 组件实例id
	 */
	@ApiField("instance_id")
	private String instanceId;

	/** 
	 * 多方ca用印结果
	 */
	@ApiField("multi_ca_result")
	private AlsacenterMultiCaResult multiCaResult;

	/** 
	 * 纸质用印结果
	 */
	@ApiField("paper_seal_result")
	private AlsacenterPaperSealResult paperSealResult;

	/** 
	 * 半份签用印结果
	 */
	@ApiField("part_ca_result")
	private AlsacenterPartCaResult partCaResult;

	/** 
	 * 签署方式
	 */
	@ApiField("sign_method")
	private String signMethod;

	/** 
	 * 单方ca用印结果
	 */
	@ApiField("single_ca_result")
	private AlsacenterSingleCaResult singleCaResult;

	public void setBlockchainResult(AlsacenterBlockchainResult blockchainResult) {
		this.blockchainResult = blockchainResult;
	}
	public AlsacenterBlockchainResult getBlockchainResult( ) {
		return this.blockchainResult;
	}

	public void setDocusignResult(AlsacenterDocusignResult docusignResult) {
		this.docusignResult = docusignResult;
	}
	public AlsacenterDocusignResult getDocusignResult( ) {
		return this.docusignResult;
	}

	public void setFlowId(String flowId) {
		this.flowId = flowId;
	}
	public String getFlowId( ) {
		return this.flowId;
	}

	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}
	public String getInstanceId( ) {
		return this.instanceId;
	}

	public void setMultiCaResult(AlsacenterMultiCaResult multiCaResult) {
		this.multiCaResult = multiCaResult;
	}
	public AlsacenterMultiCaResult getMultiCaResult( ) {
		return this.multiCaResult;
	}

	public void setPaperSealResult(AlsacenterPaperSealResult paperSealResult) {
		this.paperSealResult = paperSealResult;
	}
	public AlsacenterPaperSealResult getPaperSealResult( ) {
		return this.paperSealResult;
	}

	public void setPartCaResult(AlsacenterPartCaResult partCaResult) {
		this.partCaResult = partCaResult;
	}
	public AlsacenterPartCaResult getPartCaResult( ) {
		return this.partCaResult;
	}

	public void setSignMethod(String signMethod) {
		this.signMethod = signMethod;
	}
	public String getSignMethod( ) {
		return this.signMethod;
	}

	public void setSingleCaResult(AlsacenterSingleCaResult singleCaResult) {
		this.singleCaResult = singleCaResult;
	}
	public AlsacenterSingleCaResult getSingleCaResult( ) {
		return this.singleCaResult;
	}

}
