package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.AcFilterDTO;
import com.alipay.api.domain.TyreLeakDTO;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alios.open.auto.status.query response.
 * 
 * @author auto create
 * @since 1.0, 2022-12-07 14:48:55
 */
public class AliosOpenAutoStatusQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 7791876198316883829L;

	/** 
	 * 需要保养的空滤模型
	 */
	@ApiListField("ac_filter")
	@ApiField("ac_filter_d_t_o")
	private List<AcFilterDTO> acFilter;

	/** 
	 * 蓄电池寿命SOH预测值
	 */
	@ApiField("battery_soh")
	private Long batterySoh;

	/** 
	 * 是否有亏电风险，0-否,1-是
	 */
	@ApiField("batterylost_risk")
	private Long batterylostRisk;

	/** 
	 * 亏电风险等级，1-中度风险，2-高度风险
	 */
	@ApiField("batterylost_risk_level")
	private Long batterylostRiskLevel;

	/** 
	 * 剩余电量百分比
	 */
	@ApiField("carstatus_abattery_remainpercent")
	private String carstatusAbatteryRemainpercent;

	/** 
	 * 剩余油量百分比
	 */
	@ApiField("carstatus_afuel_remainpercent")
	private String carstatusAfuelRemainpercent;

	/** 
	 * 历史行驶里程
	 */
	@ApiField("total_mile")
	private Long totalMile;

	/** 
	 * 胎压预警模型
	 */
	@ApiListField("tyreleak")
	@ApiField("tyre_leak_d_t_o")
	private List<TyreLeakDTO> tyreleak;

	/** 
	 * 故障报警持续时长，单位秒
	 */
	@ApiField("warning_aalert_duration")
	private Long warningAalertDuration;

	/** 
	 * 故障报警id，每个id对应一个报警/故障类型。
	 */
	@ApiField("warning_aalert_id")
	private String warningAalertId;

	/** 
	 * 故障报警日期
	 */
	@ApiField("warning_aalert_pt")
	private String warningAalertPt;

	/** 
	 * 故障报警开始时间
	 */
	@ApiField("warning_aalert_starttime")
	private String warningAalertStarttime;

	/** 
	 * 故障报警值，报警类型组成报警值说明具体的报警内容。
	 */
	@ApiField("warning_aalert_value")
	private String warningAalertValue;

	public void setAcFilter(List<AcFilterDTO> acFilter) {
		this.acFilter = acFilter;
	}
	public List<AcFilterDTO> getAcFilter( ) {
		return this.acFilter;
	}

	public void setBatterySoh(Long batterySoh) {
		this.batterySoh = batterySoh;
	}
	public Long getBatterySoh( ) {
		return this.batterySoh;
	}

	public void setBatterylostRisk(Long batterylostRisk) {
		this.batterylostRisk = batterylostRisk;
	}
	public Long getBatterylostRisk( ) {
		return this.batterylostRisk;
	}

	public void setBatterylostRiskLevel(Long batterylostRiskLevel) {
		this.batterylostRiskLevel = batterylostRiskLevel;
	}
	public Long getBatterylostRiskLevel( ) {
		return this.batterylostRiskLevel;
	}

	public void setCarstatusAbatteryRemainpercent(String carstatusAbatteryRemainpercent) {
		this.carstatusAbatteryRemainpercent = carstatusAbatteryRemainpercent;
	}
	public String getCarstatusAbatteryRemainpercent( ) {
		return this.carstatusAbatteryRemainpercent;
	}

	public void setCarstatusAfuelRemainpercent(String carstatusAfuelRemainpercent) {
		this.carstatusAfuelRemainpercent = carstatusAfuelRemainpercent;
	}
	public String getCarstatusAfuelRemainpercent( ) {
		return this.carstatusAfuelRemainpercent;
	}

	public void setTotalMile(Long totalMile) {
		this.totalMile = totalMile;
	}
	public Long getTotalMile( ) {
		return this.totalMile;
	}

	public void setTyreleak(List<TyreLeakDTO> tyreleak) {
		this.tyreleak = tyreleak;
	}
	public List<TyreLeakDTO> getTyreleak( ) {
		return this.tyreleak;
	}

	public void setWarningAalertDuration(Long warningAalertDuration) {
		this.warningAalertDuration = warningAalertDuration;
	}
	public Long getWarningAalertDuration( ) {
		return this.warningAalertDuration;
	}

	public void setWarningAalertId(String warningAalertId) {
		this.warningAalertId = warningAalertId;
	}
	public String getWarningAalertId( ) {
		return this.warningAalertId;
	}

	public void setWarningAalertPt(String warningAalertPt) {
		this.warningAalertPt = warningAalertPt;
	}
	public String getWarningAalertPt( ) {
		return this.warningAalertPt;
	}

	public void setWarningAalertStarttime(String warningAalertStarttime) {
		this.warningAalertStarttime = warningAalertStarttime;
	}
	public String getWarningAalertStarttime( ) {
		return this.warningAalertStarttime;
	}

	public void setWarningAalertValue(String warningAalertValue) {
		this.warningAalertValue = warningAalertValue;
	}
	public String getWarningAalertValue( ) {
		return this.warningAalertValue;
	}

}
