package com.alipay.api.request;

import com.alipay.api.domain.SystemParam;
import java.util.HashMap;
import java.util.Map;

import com.alipay.api.FileItem;
import com.alipay.api.AlipayUploadRequest;
import com.alipay.api.internal.util.AlipayHashMap;
import com.alipay.api.response.AnttechBlockchainDefinDataserviceOcrfileUploadResponse;
import com.alipay.api.AlipayObject;

/**
 * ALIPAY API: anttech.blockchain.defin.dataservice.ocrfile.upload request
 * 
 * @author auto create
 * @since 1.0, 2021-08-20 18:14:25
 */
public class AnttechBlockchainDefinDataserviceOcrfileUploadRequest implements AlipayUploadRequest<AnttechBlockchainDefinDataserviceOcrfileUploadResponse> {

	private AlipayHashMap udfParams; // add user-defined text parameters
	private String apiVersion="1.0";

	/** 
	* 业务参数
	 */
	private String encodedBizParam;

	/** 
	* 待上传文件
	 */
	private FileItem fileContent;

	/** 
	* 系统参数
	 */
	private SystemParam sysParam;

	public void setEncodedBizParam(String encodedBizParam) {
		this.encodedBizParam = encodedBizParam;
	}
	public String getEncodedBizParam() {
		return this.encodedBizParam;
	}

	public void setFileContent(FileItem fileContent) {
		this.fileContent = fileContent;
	}
	public FileItem getFileContent() {
		return this.fileContent;
	}

	public void setSysParam(SystemParam sysParam) {
		this.sysParam = sysParam;
	}
	public SystemParam getSysParam() {
		return this.sysParam;
	}
	private String terminalType;
	private String terminalInfo;
	private String prodCode;
	private String notifyUrl;
	private String returnUrl;
    private boolean needEncrypt=false;
	private AlipayObject bizModel=null;

	public String getNotifyUrl() {
		return this.notifyUrl;
	}

	public void setNotifyUrl(String notifyUrl) {
		this.notifyUrl = notifyUrl;
	}

	public String getReturnUrl() {
		return this.returnUrl;
	}

	public void setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
	}

	public String getApiVersion() {
		return this.apiVersion;
	}
	public void setApiVersion(String apiVersion) {
		this.apiVersion = apiVersion;
	}

	public void setTerminalType(String terminalType){
		this.terminalType=terminalType;
	}
	
    public String getTerminalType(){
    	return this.terminalType;
    }

    public void setTerminalInfo(String terminalInfo){
    	this.terminalInfo=terminalInfo;
    }

    public String getTerminalInfo(){
    	return this.terminalInfo;
    }
	
	public String getProdCode() {
		return this.prodCode; 
	}
	
	public void setProdCode(String prodCode) {
		this.prodCode=prodCode;
	}
    
	public String getApiMethodName() {
		return "anttech.blockchain.defin.dataservice.ocrfile.upload";
	}

	public Map<String, String> getTextParams() {		
		AlipayHashMap txtParams = new AlipayHashMap();
		txtParams.put("encoded_biz_param", this.encodedBizParam);
		txtParams.put("sys_param", this.sysParam == null? null : new com.alipay.api.internal.util.json.JSONWriter().write(this.sysParam, true));
		if(udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
	
	public void putOtherTextParam(String key, String value) {
		if(this.udfParams == null) {
			this.udfParams = new AlipayHashMap();
		}
		this.udfParams.put(key, value);
	}

	public Map<String, FileItem> getFileParams() {
		Map<String, FileItem> params = new HashMap<String, FileItem>();
		params.put("file_content", this.fileContent);
		return params;
	}

	public Class<AnttechBlockchainDefinDataserviceOcrfileUploadResponse> getResponseClass() {
		return AnttechBlockchainDefinDataserviceOcrfileUploadResponse.class;
	}
	
	 public boolean isNeedEncrypt() {
    
      return this.needEncrypt;
    }


    public void setNeedEncrypt(boolean needEncrypt) {
    
         this.needEncrypt=needEncrypt;
    }
    
    public AlipayObject getBizModel() {
    
      return this.bizModel;
    }


    public void setBizModel(AlipayObject bizModel) {
    
         this.bizModel=bizModel;
    }
	
	
}
