package com.alipay.api.request;

import com.alipay.api.domain.AccessParams;
import com.alipay.api.domain.ManjiangTestThreeData;
import java.util.Map;

import com.alipay.api.AlipayRequest;
import com.alipay.api.internal.util.AlipayHashMap;
import com.alipay.api.response.AntMerchantExpandTestQueryResponse;
import com.alipay.api.AlipayObject;

/**
 * ALIPAY API: ant.merchant.expand.test.query request
 * 
 * @author auto create
 * @since 1.0, 2023-02-09 21:03:44
 */
public class AntMerchantExpandTestQueryRequest implements AlipayRequest<AntMerchantExpandTestQueryResponse> {

	private AlipayHashMap udfParams; // add user-defined text parameters
	private String apiVersion="1.0";

	/** 
	* 1
	 */
	private String ddd;

	/** 
	* 1
	 */
	private String dddOpenId;

	/** 
	* 1
	 */
	private String ssd;

	/** 
	* 2
	 */
	private Long test2;

	/** 
	* 1
	 */
	private AccessParams test3;

	/** 
	* 1
	 */
	private ManjiangTestThreeData test4;

	/** 
	* 1
	 */
	private String testBody1;

	public void setDdd(String ddd) {
		this.ddd = ddd;
	}
	public String getDdd() {
		return this.ddd;
	}

	public void setDddOpenId(String dddOpenId) {
		this.dddOpenId = dddOpenId;
	}
	public String getDddOpenId() {
		return this.dddOpenId;
	}

	public void setSsd(String ssd) {
		this.ssd = ssd;
	}
	public String getSsd() {
		return this.ssd;
	}

	public void setTest2(Long test2) {
		this.test2 = test2;
	}
	public Long getTest2() {
		return this.test2;
	}

	public void setTest3(AccessParams test3) {
		this.test3 = test3;
	}
	public AccessParams getTest3() {
		return this.test3;
	}

	public void setTest4(ManjiangTestThreeData test4) {
		this.test4 = test4;
	}
	public ManjiangTestThreeData getTest4() {
		return this.test4;
	}

	public void setTestBody1(String testBody1) {
		this.testBody1 = testBody1;
	}
	public String getTestBody1() {
		return this.testBody1;
	}
	private String terminalType;
	private String terminalInfo;	
	private String prodCode;
	private String notifyUrl;
	private String returnUrl;
	private boolean needEncrypt=false;
	private AlipayObject bizModel=null;

	public String getNotifyUrl() {
		return this.notifyUrl;
	}

	public void setNotifyUrl(String notifyUrl) {
		this.notifyUrl = notifyUrl;
	}

	public String getReturnUrl() {
		return this.returnUrl;
	}

	public void setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
	}

	public String getApiVersion() {
		return this.apiVersion;
	}

	public void setApiVersion(String apiVersion) {
		this.apiVersion = apiVersion;
	}

	public void setTerminalType(String terminalType){
		this.terminalType=terminalType;
	}

    public String getTerminalType(){
    	return this.terminalType;
    }

    public void setTerminalInfo(String terminalInfo){
    	this.terminalInfo=terminalInfo;
    }

    public String getTerminalInfo(){
    	return this.terminalInfo;
    }	

	public void setProdCode(String prodCode) {
		this.prodCode=prodCode;
	}

	public String getProdCode() {
		return this.prodCode; 
	}

	public String getApiMethodName() {
		return "ant.merchant.expand.test.query";
	}

	public Map<String, String> getTextParams() {		
		AlipayHashMap txtParams = new AlipayHashMap();
		txtParams.put("ddd", this.ddd);
		txtParams.put("ddd_open_id", this.dddOpenId);
		txtParams.put("ssd", this.ssd);
		txtParams.put("test_2", this.test2);
		txtParams.put("test_3", this.test3 == null? null : new com.alipay.api.internal.util.json.JSONWriter().write(this.test3, true));
		txtParams.put("test_4", this.test4 == null? null : new com.alipay.api.internal.util.json.JSONWriter().write(this.test4, true));
		txtParams.put("test_body_1", this.testBody1);
		if(udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public void putOtherTextParam(String key, String value) {
		if(this.udfParams == null) {
			this.udfParams = new AlipayHashMap();
		}
		this.udfParams.put(key, value);
	}

	public Class<AntMerchantExpandTestQueryResponse> getResponseClass() {
		return AntMerchantExpandTestQueryResponse.class;
	}
	

    public boolean isNeedEncrypt() {
    
      return this.needEncrypt;
    }


    public void setNeedEncrypt(boolean needEncrypt) {
    
         this.needEncrypt=needEncrypt;
    }
    
    public AlipayObject getBizModel() {
    
      return this.bizModel;
    }


    public void setBizModel(AlipayObject bizModel) {
    
         this.bizModel=bizModel;
    }
	
	
}
