package com.alipay.api.request;

import java.util.HashMap;
import java.util.Map;

import com.alipay.api.FileItem;
import com.alipay.api.AlipayUploadRequest;
import com.alipay.api.internal.util.AlipayHashMap;
import com.alipay.api.response.AlipayTradeAdvanceSettleResponse;
import com.alipay.api.AlipayObject;

/**
 * ALIPAY API: alipay.trade.advance.settle request
 * 
 * @author auto create
 * @since 1.0, 2023-05-23 17:27:14
 */
public class AlipayTradeAdvanceSettleRequest implements AlipayUploadRequest<AlipayTradeAdvanceSettleResponse> {

	private AlipayHashMap udfParams; // add user-defined text parameters
	private String apiVersion="1.0";

	/** 
	* 放款明细（文件字段），笔数最大 1000 笔
	 */
	private FileItem details;

	/** 
	* 放款明细笔数
	 */
	private Long detailsCount;

	/** 
	* 外部请求号，开发者自行生成并保证唯一性，作为业务幂等性控制
	 */
	private String outRequestNo;

	/** 
	* 结算主体账号。 当结算主体类型为SecondMerchant，本参数为二级商户的SecondaryMerchantId
	 */
	private String settleEntityId;

	/** 
	* 结算主体类型。 SecondMerchant：结算主体为二级商户
	 */
	private String settleEntityType;

	public void setDetails(FileItem details) {
		this.details = details;
	}
	public FileItem getDetails() {
		return this.details;
	}

	public void setDetailsCount(Long detailsCount) {
		this.detailsCount = detailsCount;
	}
	public Long getDetailsCount() {
		return this.detailsCount;
	}

	public void setOutRequestNo(String outRequestNo) {
		this.outRequestNo = outRequestNo;
	}
	public String getOutRequestNo() {
		return this.outRequestNo;
	}

	public void setSettleEntityId(String settleEntityId) {
		this.settleEntityId = settleEntityId;
	}
	public String getSettleEntityId() {
		return this.settleEntityId;
	}

	public void setSettleEntityType(String settleEntityType) {
		this.settleEntityType = settleEntityType;
	}
	public String getSettleEntityType() {
		return this.settleEntityType;
	}
	private String terminalType;
	private String terminalInfo;
	private String prodCode;
	private String notifyUrl;
	private String returnUrl;
    private boolean needEncrypt=false;
	private AlipayObject bizModel=null;

	public String getNotifyUrl() {
		return this.notifyUrl;
	}

	public void setNotifyUrl(String notifyUrl) {
		this.notifyUrl = notifyUrl;
	}

	public String getReturnUrl() {
		return this.returnUrl;
	}

	public void setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
	}

	public String getApiVersion() {
		return this.apiVersion;
	}
	public void setApiVersion(String apiVersion) {
		this.apiVersion = apiVersion;
	}

	public void setTerminalType(String terminalType){
		this.terminalType=terminalType;
	}
	
    public String getTerminalType(){
    	return this.terminalType;
    }

    public void setTerminalInfo(String terminalInfo){
    	this.terminalInfo=terminalInfo;
    }

    public String getTerminalInfo(){
    	return this.terminalInfo;
    }
	
	public String getProdCode() {
		return this.prodCode; 
	}
	
	public void setProdCode(String prodCode) {
		this.prodCode=prodCode;
	}
    
	public String getApiMethodName() {
		return "alipay.trade.advance.settle";
	}

	public Map<String, String> getTextParams() {		
		AlipayHashMap txtParams = new AlipayHashMap();
		txtParams.put("details_count", this.detailsCount);
		txtParams.put("out_request_no", this.outRequestNo);
		txtParams.put("settle_entity_id", this.settleEntityId);
		txtParams.put("settle_entity_type", this.settleEntityType);
		if(udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
	
	public void putOtherTextParam(String key, String value) {
		if(this.udfParams == null) {
			this.udfParams = new AlipayHashMap();
		}
		this.udfParams.put(key, value);
	}

	public Map<String, FileItem> getFileParams() {
		Map<String, FileItem> params = new HashMap<String, FileItem>();
		params.put("details", this.details);
		return params;
	}

	public Class<AlipayTradeAdvanceSettleResponse> getResponseClass() {
		return AlipayTradeAdvanceSettleResponse.class;
	}
	
	 public boolean isNeedEncrypt() {
    
      return this.needEncrypt;
    }


    public void setNeedEncrypt(boolean needEncrypt) {
    
         this.needEncrypt=needEncrypt;
    }
    
    public AlipayObject getBizModel() {
    
      return this.bizModel;
    }


    public void setBizModel(AlipayObject bizModel) {
    
         this.bizModel=bizModel;
    }
	
	
}
