package com.alipay.api.request;

import com.alipay.api.domain.OpenidComplex;
import java.util.Map;

import com.alipay.api.AlipayRequest;
import com.alipay.api.internal.util.AlipayHashMap;
import com.alipay.api.response.AlipayOpenOperationOpenbizmockNobizQueryResponse;
import com.alipay.api.AlipayObject;

/**
 * ALIPAY API: alipay.open.operation.openbizmock.nobiz.query request
 * 
 * @author auto create
 * @since 1.0, 2022-09-21 20:54:59
 */
public class AlipayOpenOperationOpenbizmockNobizQueryRequest implements AlipayRequest<AlipayOpenOperationOpenbizmockNobizQueryResponse> {

	private AlipayHashMap udfParams; // add user-defined text parameters
	private String apiVersion="1.0";

	/** 
	* 1
	 */
	private OpenidComplex test;

	/** 
	* 测试
	 */
	private String testJson;

	/** 
	* 1
	 */
	private String userId;

	/** 
	* 1
	 */
	private String userIdOpenid;

	public void setTest(OpenidComplex test) {
		this.test = test;
	}
	public OpenidComplex getTest() {
		return this.test;
	}

	public void setTestJson(String testJson) {
		this.testJson = testJson;
	}
	public String getTestJson() {
		return this.testJson;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}
	public String getUserId() {
		return this.userId;
	}

	public void setUserIdOpenid(String userIdOpenid) {
		this.userIdOpenid = userIdOpenid;
	}
	public String getUserIdOpenid() {
		return this.userIdOpenid;
	}
	private String terminalType;
	private String terminalInfo;	
	private String prodCode;
	private String notifyUrl;
	private String returnUrl;
	private boolean needEncrypt=false;
	private AlipayObject bizModel=null;

	public String getNotifyUrl() {
		return this.notifyUrl;
	}

	public void setNotifyUrl(String notifyUrl) {
		this.notifyUrl = notifyUrl;
	}

	public String getReturnUrl() {
		return this.returnUrl;
	}

	public void setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
	}

	public String getApiVersion() {
		return this.apiVersion;
	}

	public void setApiVersion(String apiVersion) {
		this.apiVersion = apiVersion;
	}

	public void setTerminalType(String terminalType){
		this.terminalType=terminalType;
	}

    public String getTerminalType(){
    	return this.terminalType;
    }

    public void setTerminalInfo(String terminalInfo){
    	this.terminalInfo=terminalInfo;
    }

    public String getTerminalInfo(){
    	return this.terminalInfo;
    }	

	public void setProdCode(String prodCode) {
		this.prodCode=prodCode;
	}

	public String getProdCode() {
		return this.prodCode; 
	}

	public String getApiMethodName() {
		return "alipay.open.operation.openbizmock.nobiz.query";
	}

	public Map<String, String> getTextParams() {		
		AlipayHashMap txtParams = new AlipayHashMap();
		txtParams.put("test", this.test == null? null : new com.alipay.api.internal.util.json.JSONWriter().write(this.test, true));
		txtParams.put("test_json", this.testJson);
		txtParams.put("user_id", this.userId);
		txtParams.put("user_id_openid", this.userIdOpenid);
		if(udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public void putOtherTextParam(String key, String value) {
		if(this.udfParams == null) {
			this.udfParams = new AlipayHashMap();
		}
		this.udfParams.put(key, value);
	}

	public Class<AlipayOpenOperationOpenbizmockNobizQueryResponse> getResponseClass() {
		return AlipayOpenOperationOpenbizmockNobizQueryResponse.class;
	}
	

    public boolean isNeedEncrypt() {
    
      return this.needEncrypt;
    }


    public void setNeedEncrypt(boolean needEncrypt) {
    
         this.needEncrypt=needEncrypt;
    }
    
    public AlipayObject getBizModel() {
    
      return this.bizModel;
    }


    public void setBizModel(AlipayObject bizModel) {
    
         this.bizModel=bizModel;
    }
	
	
}
