package com.alipay.api.request;

import java.util.HashMap;
import java.util.Map;

import com.alipay.api.FileItem;
import com.alipay.api.AlipayUploadRequest;
import com.alipay.api.internal.util.AlipayHashMap;
import com.alipay.api.response.AlipayOpenDumUploadResponse;
import com.alipay.api.AlipayObject;

/**
 * ALIPAY API: alipay.open.dum.upload request
 * 
 * @author auto create
 * @since 1.0, 2023-05-17 11:29:08
 */
public class AlipayOpenDumUploadRequest implements AlipayUploadRequest<AlipayOpenDumUploadResponse> {

	private AlipayHashMap udfParams; // add user-defined text parameters
	private String apiVersion="1.0";

	/** 
	* 字段描述body参数a
	 */
	private String bodyA;

	/** 
	* 基础描述
	 */
	private FileItem bodyB;

	/** 
	* 字段描述body参数a
	 */
	private String bodyOpenId;

	/** 
	* patha
	 */
	private String pathA;

	/** 
	* 字段描述
	 */
	private String queryA;

	public void setBodyA(String bodyA) {
		this.bodyA = bodyA;
	}
	public String getBodyA() {
		return this.bodyA;
	}

	public void setBodyB(FileItem bodyB) {
		this.bodyB = bodyB;
	}
	public FileItem getBodyB() {
		return this.bodyB;
	}

	public void setBodyOpenId(String bodyOpenId) {
		this.bodyOpenId = bodyOpenId;
	}
	public String getBodyOpenId() {
		return this.bodyOpenId;
	}

	public void setPathA(String pathA) {
		this.pathA = pathA;
	}
	public String getPathA() {
		return this.pathA;
	}

	public void setQueryA(String queryA) {
		this.queryA = queryA;
	}
	public String getQueryA() {
		return this.queryA;
	}
	private String terminalType;
	private String terminalInfo;
	private String prodCode;
	private String notifyUrl;
	private String returnUrl;
    private boolean needEncrypt=false;
	private AlipayObject bizModel=null;

	public String getNotifyUrl() {
		return this.notifyUrl;
	}

	public void setNotifyUrl(String notifyUrl) {
		this.notifyUrl = notifyUrl;
	}

	public String getReturnUrl() {
		return this.returnUrl;
	}

	public void setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
	}

	public String getApiVersion() {
		return this.apiVersion;
	}
	public void setApiVersion(String apiVersion) {
		this.apiVersion = apiVersion;
	}

	public void setTerminalType(String terminalType){
		this.terminalType=terminalType;
	}
	
    public String getTerminalType(){
    	return this.terminalType;
    }

    public void setTerminalInfo(String terminalInfo){
    	this.terminalInfo=terminalInfo;
    }

    public String getTerminalInfo(){
    	return this.terminalInfo;
    }
	
	public String getProdCode() {
		return this.prodCode; 
	}
	
	public void setProdCode(String prodCode) {
		this.prodCode=prodCode;
	}
    
	public String getApiMethodName() {
		return "alipay.open.dum.upload";
	}

	public Map<String, String> getTextParams() {		
		AlipayHashMap txtParams = new AlipayHashMap();
		txtParams.put("body_a", this.bodyA);
		txtParams.put("body_open_id", this.bodyOpenId);
		txtParams.put("path_a", this.pathA);
		txtParams.put("query_a", this.queryA);
		if(udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
	
	public void putOtherTextParam(String key, String value) {
		if(this.udfParams == null) {
			this.udfParams = new AlipayHashMap();
		}
		this.udfParams.put(key, value);
	}

	public Map<String, FileItem> getFileParams() {
		Map<String, FileItem> params = new HashMap<String, FileItem>();
		params.put("body_b", this.bodyB);
		return params;
	}

	public Class<AlipayOpenDumUploadResponse> getResponseClass() {
		return AlipayOpenDumUploadResponse.class;
	}
	
	 public boolean isNeedEncrypt() {
    
      return this.needEncrypt;
    }


    public void setNeedEncrypt(boolean needEncrypt) {
    
         this.needEncrypt=needEncrypt;
    }
    
    public AlipayObject getBizModel() {
    
      return this.bizModel;
    }


    public void setBizModel(AlipayObject bizModel) {
    
         this.bizModel=bizModel;
    }
	
	
}
