package com.alipay.api.request;

import java.util.Map;

import com.alipay.api.AlipayRequest;
import com.alipay.api.internal.util.AlipayHashMap;
import com.alipay.api.response.AlipayOpenBencftestRefundconfirmResponse;
import com.alipay.api.AlipayObject;

/**
 * ALIPAY API: alipay.open.bencftest.refundconfirm request
 * 
 * @author auto create
 * @since 1.0, 2023-05-10 11:22:15
 */
public class AlipayOpenBencftestRefundconfirmRequest implements AlipayRequest<AlipayOpenBencftestRefundconfirmResponse> {

	private AlipayHashMap udfParams; // add user-defined text parameters
	private String apiVersion="1.0";

	/** 
	* 1
	 */
	private String b3;

	/** 
	* 1
	 */
	private String ddf;

	/** 
	* 1
	 */
	private String op;

	public void setB3(String b3) {
		this.b3 = b3;
	}
	public String getB3() {
		return this.b3;
	}

	public void setDdf(String ddf) {
		this.ddf = ddf;
	}
	public String getDdf() {
		return this.ddf;
	}

	public void setOp(String op) {
		this.op = op;
	}
	public String getOp() {
		return this.op;
	}
	private String terminalType;
	private String terminalInfo;	
	private String prodCode;
	private String notifyUrl;
	private String returnUrl;
	private boolean needEncrypt=false;
	private AlipayObject bizModel=null;

	public String getNotifyUrl() {
		return this.notifyUrl;
	}

	public void setNotifyUrl(String notifyUrl) {
		this.notifyUrl = notifyUrl;
	}

	public String getReturnUrl() {
		return this.returnUrl;
	}

	public void setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
	}

	public String getApiVersion() {
		return this.apiVersion;
	}

	public void setApiVersion(String apiVersion) {
		this.apiVersion = apiVersion;
	}

	public void setTerminalType(String terminalType){
		this.terminalType=terminalType;
	}

    public String getTerminalType(){
    	return this.terminalType;
    }

    public void setTerminalInfo(String terminalInfo){
    	this.terminalInfo=terminalInfo;
    }

    public String getTerminalInfo(){
    	return this.terminalInfo;
    }	

	public void setProdCode(String prodCode) {
		this.prodCode=prodCode;
	}

	public String getProdCode() {
		return this.prodCode; 
	}

	public String getApiMethodName() {
		return "alipay.open.bencftest.refundconfirm";
	}

	public Map<String, String> getTextParams() {		
		AlipayHashMap txtParams = new AlipayHashMap();
		txtParams.put("b_3", this.b3);
		txtParams.put("ddf", this.ddf);
		txtParams.put("op", this.op);
		if(udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public void putOtherTextParam(String key, String value) {
		if(this.udfParams == null) {
			this.udfParams = new AlipayHashMap();
		}
		this.udfParams.put(key, value);
	}

	public Class<AlipayOpenBencftestRefundconfirmResponse> getResponseClass() {
		return AlipayOpenBencftestRefundconfirmResponse.class;
	}
	

    public boolean isNeedEncrypt() {
    
      return this.needEncrypt;
    }


    public void setNeedEncrypt(boolean needEncrypt) {
    
         this.needEncrypt=needEncrypt;
    }
    
    public AlipayObject getBizModel() {
    
      return this.bizModel;
    }


    public void setBizModel(AlipayObject bizModel) {
    
         this.bizModel=bizModel;
    }
	
	
}
