package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 企业数据资产服务查询
 *
 * @author auto create
 * @since 1.0, 2022-06-15 17:52:06
 */
public class ZhimaCreditEpDataProductQueryModel extends AlipayObject {

	private static final long serialVersionUID = 6696287954927394782L;

	/**
	 * 企业证件号，统一社会信用代码或营业执照注册号(查询企业维度数据时必传)
	 */
	@ApiField("ep_cert_no")
	private String epCertNo;

	/**
	 * 风报账号邮箱
	 */
	@ApiField("fb_account_email")
	private String fbAccountEmail;

	/**
	 * 分页查询页码
	 */
	@ApiField("page_index")
	private Long pageIndex;

	/**
	 * 分页查询单页大小
	 */
	@ApiField("page_size")
	private Long pageSize;

	/**
	 * 数据资产服务产品码
	 */
	@ApiField("product_code")
	private String productCode;

	public String getEpCertNo() {
		return this.epCertNo;
	}
	public void setEpCertNo(String epCertNo) {
		this.epCertNo = epCertNo;
	}

	public String getFbAccountEmail() {
		return this.fbAccountEmail;
	}
	public void setFbAccountEmail(String fbAccountEmail) {
		this.fbAccountEmail = fbAccountEmail;
	}

	public Long getPageIndex() {
		return this.pageIndex;
	}
	public void setPageIndex(Long pageIndex) {
		this.pageIndex = pageIndex;
	}

	public Long getPageSize() {
		return this.pageSize;
	}
	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public String getProductCode() {
		return this.productCode;
	}
	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

}
