package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 券详情信息
 *
 * @author auto create
 * @since 1.0, 2022-08-31 11:39:04
 */
public class VoucherInstanceDetailInfo extends AlipayObject {

	private static final long serialVersionUID = 6799764349749168545L;

	/**
	 * 券生效时间，格式为：yyyy-MM-dd HH:mm:ss。
	 */
	@ApiField("gmt_active")
	private Date gmtActive;

	/**
	 * 券失效时间，格式为：yyyy-MM-dd HH:mm:ss。
	 */
	@ApiField("gmt_expired")
	private Date gmtExpired;

	/**
	 * 服务商发放的券码。
限制： 单个code最长64位。 code允许包含的字符有0-9、a-z、A-Z、-、_、+、=、|。
	 */
	@ApiField("voucher_code_bar_code")
	private String voucherCodeBarCode;

	/**
	 * 券状态
	 */
	@ApiField("voucher_status")
	private String voucherStatus;

	public Date getGmtActive() {
		return this.gmtActive;
	}
	public void setGmtActive(Date gmtActive) {
		this.gmtActive = gmtActive;
	}

	public Date getGmtExpired() {
		return this.gmtExpired;
	}
	public void setGmtExpired(Date gmtExpired) {
		this.gmtExpired = gmtExpired;
	}

	public String getVoucherCodeBarCode() {
		return this.voucherCodeBarCode;
	}
	public void setVoucherCodeBarCode(String voucherCodeBarCode) {
		this.voucherCodeBarCode = voucherCodeBarCode;
	}

	public String getVoucherStatus() {
		return this.voucherStatus;
	}
	public void setVoucherStatus(String voucherStatus) {
		this.voucherStatus = voucherStatus;
	}

}
