package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 用户扣款信息
 *
 * @author auto create
 * @since 1.0, 2022-07-13 16:50:33
 */
public class UserDeductInfo extends AlipayObject {

	private static final long serialVersionUID = 5779871722614196376L;

	/**
	 * 支付宝用户id
	 */
	@ApiField("alipay_user_id")
	private String alipayUserId;

	/**
	 * 扩展信息，json格式
	 */
	@ApiField("ext")
	private String ext;

	/**
	 * 机构侧用户扣款金额 单位为元 类型为人民币
	 */
	@ApiField("inst_deduction_amt")
	private String instDeductionAmt;

	/**
	 * 逾期借据号列表，从逾期查询接口拿到的过滤后的逾期合约列表
	 */
	@ApiListField("ovd_loan_nos")
	@ApiField("string")
	private List<String> ovdLoanNos;

	public String getAlipayUserId() {
		return this.alipayUserId;
	}
	public void setAlipayUserId(String alipayUserId) {
		this.alipayUserId = alipayUserId;
	}

	public String getExt() {
		return this.ext;
	}
	public void setExt(String ext) {
		this.ext = ext;
	}

	public String getInstDeductionAmt() {
		return this.instDeductionAmt;
	}
	public void setInstDeductionAmt(String instDeductionAmt) {
		this.instDeductionAmt = instDeductionAmt;
	}

	public List<String> getOvdLoanNos() {
		return this.ovdLoanNos;
	}
	public void setOvdLoanNos(List<String> ovdLoanNos) {
		this.ovdLoanNos = ovdLoanNos;
	}

}
