package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 联营卡卡信息，包括索引卡号，卡状态等信息
 *
 * @author auto create
 * @since 1.0, 2021-05-13 16:46:09
 */
public class UnionAccountApiVO extends AlipayObject {

	private static final long serialVersionUID = 4523562986382413273L;

	/**
	 * 联营卡索引卡号，为避免传输明文卡号造成信用卡信息泄露，返回索引卡号来对应明文卡号标识一张卡
	 */
	@ApiField("account_no")
	private String accountNo;

	/**
	 * 联营卡申请状态，联营卡发卡场景下用户申请联营卡的状态，例如申请中返回AP，审核成功AS，激活成功WS等
	 */
	@ApiField("account_status")
	private String accountStatus;

	/**
	 * 联营卡信息业务id，联营卡发卡场景下通过biz_type+biz_no能够唯一确定一张联营卡信息，因此传入该参数来获取指定卡的信息，通过接口alipay.financialnet.auth.unioncard.info.batchquery获取
	 */
	@ApiField("biz_no")
	private String bizNo;

	/**
	 * 联营卡发卡类型，联营卡发卡场景下通过该参数查询用户指定类型的卡信息列表，例如饿了么联营卡应填入ELM_U_CARD，由联营卡发卡平台同学定义
	 */
	@ApiField("biz_type")
	private String bizType;

	/**
	 * 联营卡卡号脱敏后4位，联营卡信息中返回给调用方的卡号展示时使用
	 */
	@ApiField("display_account_no")
	private String displayAccountNo;

	/**
	 * 联营卡申请创建时间
	 */
	@ApiField("gmt_create")
	private String gmtCreate;

	/**
	 * 联营卡发卡机构id，联营卡发卡场景下通过该参数过滤指定银行的联营卡信息，例如宁波银行填入NBBANK，通过联营卡发卡平台同学获取该值
	 */
	@ApiField("inst_id")
	private String instId;

	/**
	 * 支付宝用户id，联营卡发卡场景下用户申请的联营卡对应的支付宝账号id，该参数用作入参查询用户在支付宝域内的其他信息
	 */
	@ApiField("user_id")
	private String userId;

	public String getAccountNo() {
		return this.accountNo;
	}
	public void setAccountNo(String accountNo) {
		this.accountNo = accountNo;
	}

	public String getAccountStatus() {
		return this.accountStatus;
	}
	public void setAccountStatus(String accountStatus) {
		this.accountStatus = accountStatus;
	}

	public String getBizNo() {
		return this.bizNo;
	}
	public void setBizNo(String bizNo) {
		this.bizNo = bizNo;
	}

	public String getBizType() {
		return this.bizType;
	}
	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getDisplayAccountNo() {
		return this.displayAccountNo;
	}
	public void setDisplayAccountNo(String displayAccountNo) {
		this.displayAccountNo = displayAccountNo;
	}

	public String getGmtCreate() {
		return this.gmtCreate;
	}
	public void setGmtCreate(String gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public String getInstId() {
		return this.instId;
	}
	public void setInstId(String instId) {
		this.instId = instId;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
