package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 胎压预警模型
 *
 * @author auto create
 * @since 1.0, 2020-04-09 15:22:52
 */
public class TyreLeakDTO extends AlipayObject {

	private static final long serialVersionUID = 4598292988526321152L;

	/**
	 * 是否有4轮胎压相差较大现象：0-否，1-是
	 */
	@ApiField("big_gap_of_tyres_pressure")
	private Long bigGapOfTyresPressure;

	/**
	 * 3天内是否有低压风险：0-否，1-是
	 */
	@ApiField("low_tyrepressure_risk_future_3_days")
	private Long lowTyrepressureRiskFuture3Days;

	/**
	 * 是否有慢漏气风险，0-否，1-是
	 */
	@ApiField("slowly_leak_risk")
	private Long slowlyLeakRisk;

	/**
	 * 轮胎位置，码表如下： front_left 左前轮 front_right 右前轮 rear_left 左后轮 rear_right 右后轮
	 */
	@ApiField("tyre_sign")
	private String tyreSign;

	public Long getBigGapOfTyresPressure() {
		return this.bigGapOfTyresPressure;
	}
	public void setBigGapOfTyresPressure(Long bigGapOfTyresPressure) {
		this.bigGapOfTyresPressure = bigGapOfTyresPressure;
	}

	public Long getLowTyrepressureRiskFuture3Days() {
		return this.lowTyrepressureRiskFuture3Days;
	}
	public void setLowTyrepressureRiskFuture3Days(Long lowTyrepressureRiskFuture3Days) {
		this.lowTyrepressureRiskFuture3Days = lowTyrepressureRiskFuture3Days;
	}

	public Long getSlowlyLeakRisk() {
		return this.slowlyLeakRisk;
	}
	public void setSlowlyLeakRisk(Long slowlyLeakRisk) {
		this.slowlyLeakRisk = slowlyLeakRisk;
	}

	public String getTyreSign() {
		return this.tyreSign;
	}
	public void setTyreSign(String tyreSign) {
		this.tyreSign = tyreSign;
	}

}
