package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 用户行程信息
 *
 * @author auto create
 * @since 1.0, 2021-12-16 17:16:41
 */
public class TransInfo extends AlipayObject {

	private static final long serialVersionUID = 2743317258228244235L;

	/**
	 * 业务时间
	 */
	@ApiField("biz_time")
	private String bizTime;

	/**
	 * 支付宝分配的卡类型
	 */
	@ApiField("card_type")
	private String cardType;

	/**
	 * 交易金额，单位元
	 */
	@ApiField("order_amount")
	private String orderAmount;

	/**
	 * 支付宝交易号
	 */
	@ApiField("trade_no")
	private String tradeNo;

	/**
	 * 蚂蚁统一会员ID
	 */
	@ApiField("user_id")
	private String userId;

	public String getBizTime() {
		return this.bizTime;
	}
	public void setBizTime(String bizTime) {
		this.bizTime = bizTime;
	}

	public String getCardType() {
		return this.cardType;
	}
	public void setCardType(String cardType) {
		this.cardType = cardType;
	}

	public String getOrderAmount() {
		return this.orderAmount;
	}
	public void setOrderAmount(String orderAmount) {
		this.orderAmount = orderAmount;
	}

	public String getTradeNo() {
		return this.tradeNo;
	}
	public void setTradeNo(String tradeNo) {
		this.tradeNo = tradeNo;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
