package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * dataphin时间周期对象
 *
 * @author auto create
 * @since 1.0, 2021-09-09 14:44:02
 */
public class TimePeriodDTO extends AlipayObject {

	private static final long serialVersionUID = 3764216882674776619L;

	/**
	 * 统计周期中文名
	 */
	@ApiField("cn")
	private String cn;

	/**
	 * 时间周期英文名
ex:
wtd（周初截止当日）
1d（最近1天）...

具体见 https://dataphin.alipay.com/dataplan/modelspace/define
	 */
	@ApiField("name")
	private String name;

	public String getCn() {
		return this.cn;
	}
	public void setCn(String cn) {
		this.cn = cn;
	}

	public String getName() {
		return this.name;
	}
	public void setName(String name) {
		this.name = name;
	}

}
