package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 店铺
 *
 * @author auto create
 * @since 1.0, 2022-04-01 14:48:53
 */
public class Store extends AlipayObject {

	private static final long serialVersionUID = 7455149247267321457L;

	/**
	 * 外部的店铺id
	 */
	@ApiField("referencestoreid")
	private String referencestoreid;

	/**
	 * 店铺地址
	 */
	@ApiField("storeaddress")
	private IcAddress storeaddress;

	/**
	 * aa
	 */
	@ApiListField("storeattachments")
	@ApiField("ic_attachment")
	private List<IcAttachment> storeattachments;

	/**
	 * SHAREHOLDER;LEGAL_REPRESENTATIVE;BOARD_MEMBER
	 */
	@ApiListField("storecontactpersons")
	@ApiField("string")
	private List<String> storecontactpersons;

	/**
	 * 店铺的联系方式
	 */
	@ApiListField("storecontactways")
	@ApiField("ic_contact_way")
	private List<IcContactWay> storecontactways;

	/**
	 * 店铺唯一标志
	 */
	@ApiField("storeid")
	private String storeid;

	/**
	 * 店铺MCC
	 */
	@ApiField("storemcc")
	private String storemcc;

	/**
	 * Store Name.
	 */
	@ApiField("storename")
	private String storename;

	/**
	 * 店铺网站
	 */
	@ApiListField("storewebsites")
	@ApiField("website")
	private List<Website> storewebsites;

	public String getReferencestoreid() {
		return this.referencestoreid;
	}
	public void setReferencestoreid(String referencestoreid) {
		this.referencestoreid = referencestoreid;
	}

	public IcAddress getStoreaddress() {
		return this.storeaddress;
	}
	public void setStoreaddress(IcAddress storeaddress) {
		this.storeaddress = storeaddress;
	}

	public List<IcAttachment> getStoreattachments() {
		return this.storeattachments;
	}
	public void setStoreattachments(List<IcAttachment> storeattachments) {
		this.storeattachments = storeattachments;
	}

	public List<String> getStorecontactpersons() {
		return this.storecontactpersons;
	}
	public void setStorecontactpersons(List<String> storecontactpersons) {
		this.storecontactpersons = storecontactpersons;
	}

	public List<IcContactWay> getStorecontactways() {
		return this.storecontactways;
	}
	public void setStorecontactways(List<IcContactWay> storecontactways) {
		this.storecontactways = storecontactways;
	}

	public String getStoreid() {
		return this.storeid;
	}
	public void setStoreid(String storeid) {
		this.storeid = storeid;
	}

	public String getStoremcc() {
		return this.storemcc;
	}
	public void setStoremcc(String storemcc) {
		this.storemcc = storemcc;
	}

	public String getStorename() {
		return this.storename;
	}
	public void setStorename(String storename) {
		this.storename = storename;
	}

	public List<Website> getStorewebsites() {
		return this.storewebsites;
	}
	public void setStorewebsites(List<Website> storewebsites) {
		this.storewebsites = storewebsites;
	}

}
