package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 服务记录
 *
 * @author auto create
 * @since 1.0, 2021-05-21 14:34:04
 */
public class ServiceRecord extends AlipayObject {

	private static final long serialVersionUID = 1279377544498736421L;

	/**
	 * 租户实例id（数据权限id）
	 */
	@ApiField("ccs_instance_id")
	private String ccsInstanceId;

	/**
	 * 服务创建时间，采用UTC时间，按照ISO8601标准表示
	 */
	@ApiField("create_time")
	private Date createTime;

	/**
	 * 服务记录详情
	 */
	@ApiListField("details")
	@ApiField("service_record_detail")
	private List<ServiceRecordDetail> details;

	/**
	 * 服务完结或者废弃时间，可为空
	 */
	@ApiField("finish_time")
	private Date finishTime;

	/**
	 * 服务记录ID
	 */
	@ApiField("id")
	private String id;

	/**
	 * 该通服务的场景id
	 */
	@ApiField("scene_id")
	private String sceneId;

	/**
	 * 访客的id，非云客服的id，由调用方定
	 */
	@ApiField("visitor_id")
	private String visitorId;

	/**
	 * 访客地区
	 */
	@ApiField("visitor_province")
	private String visitorProvince;

	public String getCcsInstanceId() {
		return this.ccsInstanceId;
	}
	public void setCcsInstanceId(String ccsInstanceId) {
		this.ccsInstanceId = ccsInstanceId;
	}

	public Date getCreateTime() {
		return this.createTime;
	}
	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public List<ServiceRecordDetail> getDetails() {
		return this.details;
	}
	public void setDetails(List<ServiceRecordDetail> details) {
		this.details = details;
	}

	public Date getFinishTime() {
		return this.finishTime;
	}
	public void setFinishTime(Date finishTime) {
		this.finishTime = finishTime;
	}

	public String getId() {
		return this.id;
	}
	public void setId(String id) {
		this.id = id;
	}

	public String getSceneId() {
		return this.sceneId;
	}
	public void setSceneId(String sceneId) {
		this.sceneId = sceneId;
	}

	public String getVisitorId() {
		return this.visitorId;
	}
	public void setVisitorId(String visitorId) {
		this.visitorId = visitorId;
	}

	public String getVisitorProvince() {
		return this.visitorProvince;
	}
	public void setVisitorProvince(String visitorProvince) {
		this.visitorProvince = visitorProvince;
	}

}
