package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 商品实体对象结构
 *
 * @author auto create
 * @since 1.0, 2023-07-06 20:32:00
 */
public class ProductEntity extends AlipayObject {

	private static final long serialVersionUID = 5771873166262697815L;

	/**
	 * 行动点
	 */
	@ApiField("action_point")
	private String actionPoint;

	/**
	 * 品牌id
	 */
	@ApiField("brand_id")
	private String brandId;

	/**
	 * 品牌名称
	 */
	@ApiField("brand_name")
	private String brandName;

	/**
	 * IOS品牌应用ulink调起链接
	 */
	@ApiField("brand_universal_link_url_ios")
	private String brandUniversalLinkUrlIos;

	/**
	 * Android应用品牌直达调起链接
	 */
	@ApiField("brand_url_android")
	private String brandUrlAndroid;

	/**
	 * 品牌通用落地页链接
	 */
	@ApiField("brand_url_common")
	private String brandUrlCommon;

	/**
	 * H5品牌落地页链接
	 */
	@ApiField("brand_url_h_5")
	private String brandUrlH5;

	/**
	 * IOS应用品牌直达调起链接
	 */
	@ApiField("brand_url_ios")
	private String brandUrlIos;

	/**
	 * PC端品牌落地页链接
	 */
	@ApiField("brand_url_pc")
	private String brandUrlPc;

	/**
	 * 类目特征，json字符串
	 */
	@ApiField("cate_features")
	private String cateFeatures;

	/**
	 * 叶子类目id
	 */
	@ApiField("cate_id")
	private String cateId;

	/**
	 * 叶子类目层级，1、2、3、4、5级
	 */
	@ApiField("cate_level")
	private String cateLevel;

	/**
	 * 一级类目id
	 */
	@ApiField("cate_level_1_id")
	private String cateLevel1Id;

	/**
	 * 一级类目名称
	 */
	@ApiField("cate_level_1_name")
	private String cateLevel1Name;

	/**
	 * 二级类目id
	 */
	@ApiField("cate_level_2_id")
	private String cateLevel2Id;

	/**
	 * 二级类目名称
	 */
	@ApiField("cate_level_2_name")
	private String cateLevel2Name;

	/**
	 * 三级类目id
	 */
	@ApiField("cate_level_3_id")
	private String cateLevel3Id;

	/**
	 * 三级类目名称
	 */
	@ApiField("cate_level_3_name")
	private String cateLevel3Name;

	/**
	 * 四级类目id
	 */
	@ApiField("cate_level_4_id")
	private String cateLevel4Id;

	/**
	 * 四级类目名称
	 */
	@ApiField("cate_level_4_name")
	private String cateLevel4Name;

	/**
	 * 五级类目id
	 */
	@ApiField("cate_level_5_id")
	private String cateLevel5Id;

	/**
	 * 五级类目名称
	 */
	@ApiField("cate_level_5_name")
	private String cateLevel5Name;

	/**
	 * 叶子类目名称
	 */
	@ApiField("cate_name")
	private String cateName;

	/**
	 * 商品可售卖的城市，默认不限，多个用逗号隔开
	 */
	@ApiField("city_list")
	private String cityList;

	/**
	 * 品类id
	 */
	@ApiField("commodity_id")
	private String commodityId;

	/**
	 * 品类名称
	 */
	@ApiField("commodity_name")
	private String commodityName;

	/**
	 * 商品折扣率，如0.75
	 */
	@ApiField("discount")
	private String discount;

	/**
	 * 英文品牌名
	 */
	@ApiField("en_brand_name")
	private String enBrandName;

	/**
	 * 商品的具体描述
	 */
	@ApiField("entity_desc")
	private String entityDesc;

	/**
	 * 商品名称
	 */
	@ApiField("entity_name")
	private String entityName;

	/**
	 * 商品在灯火内部唯一编号,由灯火系统生成,上传或新建商品时不传
	 */
	@ApiField("entity_no")
	private String entityNo;

	/**
	 * 商品实体状态,由商品原始状态自动生成,上传商品时不上传
	 */
	@ApiField("entity_status")
	private String entityStatus;

	/**
	 * 商品实体类型code，由灯火分配
	 */
	@ApiField("entity_type")
	private String entityType;

	/**
	 * 用户输入的自定义属性，json字符串
	 */
	@ApiField("feature_list")
	private String featureList;

	/**
	 * 是否支持假一赔十，1-支持，0-不支持
	 */
	@ApiField("is_folt")
	private Long isFolt;

	/**
	 * 是否成团预售，1-是，0-不是
	 */
	@ApiField("is_group_pre_sale")
	private Long isGroupPreSale;

	/**
	 * 商品是否提前预售，1-预售商品，0-非预售商品
	 */
	@ApiField("is_pre_sale")
	private Long isPreSale;

	/**
	 * 是否支持7天无理由退货，1-支持，0-不支持
	 */
	@ApiField("is_refundable")
	private Long isRefundable;

	/**
	 * 是否sku预售，1-是，0-不是
	 */
	@ApiField("is_sku_pre_sale")
	private Long isSkuPreSale;

	/**
	 * 商品的展示主图
	 */
	@ApiField("main_pic_url")
	private String mainPicUrl;

	/**
	 * 商品下线时间，unix时间戳类型
	 */
	@ApiField("offline_time")
	private String offlineTime;

	/**
	 * 商品上线时间，unix时间戳类型
	 */
	@ApiField("online_time")
	private String onlineTime;

	/**
	 * 商品单次限购量
	 */
	@ApiField("order_limit")
	private Long orderLimit;

	/**
	 * 商品原价
	 */
	@ApiField("ori_price")
	private Long oriPrice;

	/**
	 * 商品外部唯一id
	 */
	@ApiField("out_id")
	private String outId;

	/**
	 * 商品外部来源code，由灯火分配
	 */
	@ApiField("out_source")
	private String outSource;

	/**
	 * 商家的地址详情，若有线下门店
	 */
	@ApiField("owner_address")
	private String ownerAddress;

	/**
	 * 商家的具体名称
	 */
	@ApiField("owner_name")
	private String ownerName;

	/**
	 * 支付宝商家pid
	 */
	@ApiField("owner_pid")
	private String ownerPid;

	/**
	 * 商家IOS应用ulink调起链接
	 */
	@ApiField("owner_universal_link_url_ios")
	private String ownerUniversalLinkUrlIos;

	/**
	 * 商家Android应用直达调起链接
	 */
	@ApiField("owner_url_android")
	private String ownerUrlAndroid;

	/**
	 * 商家的通用落地页链接
	 */
	@ApiField("owner_url_common")
	private String ownerUrlCommon;

	/**
	 * 商家H5落地页链接
	 */
	@ApiField("owner_url_h_5")
	private String ownerUrlH5;

	/**
	 * 商家IOS应用直达调起链接
	 */
	@ApiField("owner_url_ios")
	private String ownerUrlIos;

	/**
	 * 商家pc端落地页链接
	 */
	@ApiField("owner_url_pc")
	private String ownerUrlPc;

	/**
	 * 扩展商品图,商品图片的补充,多个用逗号隔开
	 */
	@ApiField("pic_url_list")
	private String picUrlList;

	/**
	 * 预售时间，UNIX时间戳
	 */
	@ApiField("pre_sale_time")
	private Long preSaleTime;

	/**
	 * 商品当前价格
	 */
	@ApiField("price")
	private Long price;

	/**
	 * 商品价格单位，1-分；2-虚拟资产等
	 */
	@ApiField("price_unit")
	private Long priceUnit;

	/**
	 * 商品固有属性信息，如：品牌、产地、包装方式、净含量、单果规格，json字符串
	 */
	@ApiField("property_list")
	private String propertyList;

	/**
	 * 商品可售卖省份，默认不限，多个用逗号隔开
	 */
	@ApiField("province_list")
	private String provinceList;

	/**
	 * 商品减价
	 */
	@ApiField("saving")
	private Long saving;

	/**
	 * 商品sku列表信息，json数据结构
	 */
	@ApiField("sku_detail_list")
	private String skuDetailList;

	/**
	 * 商品关联的sku id列表
	 */
	@ApiField("sku_id_list")
	private String skuIdList;

	/**
	 * 商品原始状态,是否有效等
	 */
	@ApiField("source_status")
	private String sourceStatus;

	/**
	 * 商品spu id
	 */
	@ApiField("spu_id")
	private String spuId;

	/**
	 * 商品库存量，可调用库存更新接口直接更新
	 */
	@ApiField("stock_quantity")
	private Long stockQuantity;

	/**
	 * 商品库存状态，0-有库存，1-无库存
	 */
	@ApiField("stock_status")
	private Long stockStatus;

	/**
	 * 商品新旧程度，0-全新，1-二手，3-闲置
	 */
	@ApiField("stuff_status")
	private Long stuffStatus;

	/**
	 * 商品的副标题
	 */
	@ApiField("sub_title")
	private String subTitle;

	/**
	 * 商品标签列表,key-value的形式
	 */
	@ApiField("tag_list")
	private String tagList;

	/**
	 * Android应用直达落地页
	 */
	@ApiField("target_url_android_app")
	private String targetUrlAndroidApp;

	/**
	 * 商品通用落地页URL
	 */
	@ApiField("target_url_common")
	private String targetUrlCommon;

	/**
	 * H5页面商品落地页URL
	 */
	@ApiField("target_url_h_5")
	private String targetUrlH5;

	/**
	 * IOS应用商品直达调起链接
	 */
	@ApiField("target_url_ios_app")
	private String targetUrlIosApp;

	/**
	 * PC端商品落地页URL
	 */
	@ApiField("target_url_pc")
	private String targetUrlPc;

	/**
	 * IOS应用商品调起ulink链接
	 */
	@ApiField("target_url_universal_link")
	private String targetUrlUniversalLink;

	/**
	 * 商品的标题
	 */
	@ApiField("title")
	private String title;

	public String getActionPoint() {
		return this.actionPoint;
	}
	public void setActionPoint(String actionPoint) {
		this.actionPoint = actionPoint;
	}

	public String getBrandId() {
		return this.brandId;
	}
	public void setBrandId(String brandId) {
		this.brandId = brandId;
	}

	public String getBrandName() {
		return this.brandName;
	}
	public void setBrandName(String brandName) {
		this.brandName = brandName;
	}

	public String getBrandUniversalLinkUrlIos() {
		return this.brandUniversalLinkUrlIos;
	}
	public void setBrandUniversalLinkUrlIos(String brandUniversalLinkUrlIos) {
		this.brandUniversalLinkUrlIos = brandUniversalLinkUrlIos;
	}

	public String getBrandUrlAndroid() {
		return this.brandUrlAndroid;
	}
	public void setBrandUrlAndroid(String brandUrlAndroid) {
		this.brandUrlAndroid = brandUrlAndroid;
	}

	public String getBrandUrlCommon() {
		return this.brandUrlCommon;
	}
	public void setBrandUrlCommon(String brandUrlCommon) {
		this.brandUrlCommon = brandUrlCommon;
	}

	public String getBrandUrlH5() {
		return this.brandUrlH5;
	}
	public void setBrandUrlH5(String brandUrlH5) {
		this.brandUrlH5 = brandUrlH5;
	}

	public String getBrandUrlIos() {
		return this.brandUrlIos;
	}
	public void setBrandUrlIos(String brandUrlIos) {
		this.brandUrlIos = brandUrlIos;
	}

	public String getBrandUrlPc() {
		return this.brandUrlPc;
	}
	public void setBrandUrlPc(String brandUrlPc) {
		this.brandUrlPc = brandUrlPc;
	}

	public String getCateFeatures() {
		return this.cateFeatures;
	}
	public void setCateFeatures(String cateFeatures) {
		this.cateFeatures = cateFeatures;
	}

	public String getCateId() {
		return this.cateId;
	}
	public void setCateId(String cateId) {
		this.cateId = cateId;
	}

	public String getCateLevel() {
		return this.cateLevel;
	}
	public void setCateLevel(String cateLevel) {
		this.cateLevel = cateLevel;
	}

	public String getCateLevel1Id() {
		return this.cateLevel1Id;
	}
	public void setCateLevel1Id(String cateLevel1Id) {
		this.cateLevel1Id = cateLevel1Id;
	}

	public String getCateLevel1Name() {
		return this.cateLevel1Name;
	}
	public void setCateLevel1Name(String cateLevel1Name) {
		this.cateLevel1Name = cateLevel1Name;
	}

	public String getCateLevel2Id() {
		return this.cateLevel2Id;
	}
	public void setCateLevel2Id(String cateLevel2Id) {
		this.cateLevel2Id = cateLevel2Id;
	}

	public String getCateLevel2Name() {
		return this.cateLevel2Name;
	}
	public void setCateLevel2Name(String cateLevel2Name) {
		this.cateLevel2Name = cateLevel2Name;
	}

	public String getCateLevel3Id() {
		return this.cateLevel3Id;
	}
	public void setCateLevel3Id(String cateLevel3Id) {
		this.cateLevel3Id = cateLevel3Id;
	}

	public String getCateLevel3Name() {
		return this.cateLevel3Name;
	}
	public void setCateLevel3Name(String cateLevel3Name) {
		this.cateLevel3Name = cateLevel3Name;
	}

	public String getCateLevel4Id() {
		return this.cateLevel4Id;
	}
	public void setCateLevel4Id(String cateLevel4Id) {
		this.cateLevel4Id = cateLevel4Id;
	}

	public String getCateLevel4Name() {
		return this.cateLevel4Name;
	}
	public void setCateLevel4Name(String cateLevel4Name) {
		this.cateLevel4Name = cateLevel4Name;
	}

	public String getCateLevel5Id() {
		return this.cateLevel5Id;
	}
	public void setCateLevel5Id(String cateLevel5Id) {
		this.cateLevel5Id = cateLevel5Id;
	}

	public String getCateLevel5Name() {
		return this.cateLevel5Name;
	}
	public void setCateLevel5Name(String cateLevel5Name) {
		this.cateLevel5Name = cateLevel5Name;
	}

	public String getCateName() {
		return this.cateName;
	}
	public void setCateName(String cateName) {
		this.cateName = cateName;
	}

	public String getCityList() {
		return this.cityList;
	}
	public void setCityList(String cityList) {
		this.cityList = cityList;
	}

	public String getCommodityId() {
		return this.commodityId;
	}
	public void setCommodityId(String commodityId) {
		this.commodityId = commodityId;
	}

	public String getCommodityName() {
		return this.commodityName;
	}
	public void setCommodityName(String commodityName) {
		this.commodityName = commodityName;
	}

	public String getDiscount() {
		return this.discount;
	}
	public void setDiscount(String discount) {
		this.discount = discount;
	}

	public String getEnBrandName() {
		return this.enBrandName;
	}
	public void setEnBrandName(String enBrandName) {
		this.enBrandName = enBrandName;
	}

	public String getEntityDesc() {
		return this.entityDesc;
	}
	public void setEntityDesc(String entityDesc) {
		this.entityDesc = entityDesc;
	}

	public String getEntityName() {
		return this.entityName;
	}
	public void setEntityName(String entityName) {
		this.entityName = entityName;
	}

	public String getEntityNo() {
		return this.entityNo;
	}
	public void setEntityNo(String entityNo) {
		this.entityNo = entityNo;
	}

	public String getEntityStatus() {
		return this.entityStatus;
	}
	public void setEntityStatus(String entityStatus) {
		this.entityStatus = entityStatus;
	}

	public String getEntityType() {
		return this.entityType;
	}
	public void setEntityType(String entityType) {
		this.entityType = entityType;
	}

	public String getFeatureList() {
		return this.featureList;
	}
	public void setFeatureList(String featureList) {
		this.featureList = featureList;
	}

	public Long getIsFolt() {
		return this.isFolt;
	}
	public void setIsFolt(Long isFolt) {
		this.isFolt = isFolt;
	}

	public Long getIsGroupPreSale() {
		return this.isGroupPreSale;
	}
	public void setIsGroupPreSale(Long isGroupPreSale) {
		this.isGroupPreSale = isGroupPreSale;
	}

	public Long getIsPreSale() {
		return this.isPreSale;
	}
	public void setIsPreSale(Long isPreSale) {
		this.isPreSale = isPreSale;
	}

	public Long getIsRefundable() {
		return this.isRefundable;
	}
	public void setIsRefundable(Long isRefundable) {
		this.isRefundable = isRefundable;
	}

	public Long getIsSkuPreSale() {
		return this.isSkuPreSale;
	}
	public void setIsSkuPreSale(Long isSkuPreSale) {
		this.isSkuPreSale = isSkuPreSale;
	}

	public String getMainPicUrl() {
		return this.mainPicUrl;
	}
	public void setMainPicUrl(String mainPicUrl) {
		this.mainPicUrl = mainPicUrl;
	}

	public String getOfflineTime() {
		return this.offlineTime;
	}
	public void setOfflineTime(String offlineTime) {
		this.offlineTime = offlineTime;
	}

	public String getOnlineTime() {
		return this.onlineTime;
	}
	public void setOnlineTime(String onlineTime) {
		this.onlineTime = onlineTime;
	}

	public Long getOrderLimit() {
		return this.orderLimit;
	}
	public void setOrderLimit(Long orderLimit) {
		this.orderLimit = orderLimit;
	}

	public Long getOriPrice() {
		return this.oriPrice;
	}
	public void setOriPrice(Long oriPrice) {
		this.oriPrice = oriPrice;
	}

	public String getOutId() {
		return this.outId;
	}
	public void setOutId(String outId) {
		this.outId = outId;
	}

	public String getOutSource() {
		return this.outSource;
	}
	public void setOutSource(String outSource) {
		this.outSource = outSource;
	}

	public String getOwnerAddress() {
		return this.ownerAddress;
	}
	public void setOwnerAddress(String ownerAddress) {
		this.ownerAddress = ownerAddress;
	}

	public String getOwnerName() {
		return this.ownerName;
	}
	public void setOwnerName(String ownerName) {
		this.ownerName = ownerName;
	}

	public String getOwnerPid() {
		return this.ownerPid;
	}
	public void setOwnerPid(String ownerPid) {
		this.ownerPid = ownerPid;
	}

	public String getOwnerUniversalLinkUrlIos() {
		return this.ownerUniversalLinkUrlIos;
	}
	public void setOwnerUniversalLinkUrlIos(String ownerUniversalLinkUrlIos) {
		this.ownerUniversalLinkUrlIos = ownerUniversalLinkUrlIos;
	}

	public String getOwnerUrlAndroid() {
		return this.ownerUrlAndroid;
	}
	public void setOwnerUrlAndroid(String ownerUrlAndroid) {
		this.ownerUrlAndroid = ownerUrlAndroid;
	}

	public String getOwnerUrlCommon() {
		return this.ownerUrlCommon;
	}
	public void setOwnerUrlCommon(String ownerUrlCommon) {
		this.ownerUrlCommon = ownerUrlCommon;
	}

	public String getOwnerUrlH5() {
		return this.ownerUrlH5;
	}
	public void setOwnerUrlH5(String ownerUrlH5) {
		this.ownerUrlH5 = ownerUrlH5;
	}

	public String getOwnerUrlIos() {
		return this.ownerUrlIos;
	}
	public void setOwnerUrlIos(String ownerUrlIos) {
		this.ownerUrlIos = ownerUrlIos;
	}

	public String getOwnerUrlPc() {
		return this.ownerUrlPc;
	}
	public void setOwnerUrlPc(String ownerUrlPc) {
		this.ownerUrlPc = ownerUrlPc;
	}

	public String getPicUrlList() {
		return this.picUrlList;
	}
	public void setPicUrlList(String picUrlList) {
		this.picUrlList = picUrlList;
	}

	public Long getPreSaleTime() {
		return this.preSaleTime;
	}
	public void setPreSaleTime(Long preSaleTime) {
		this.preSaleTime = preSaleTime;
	}

	public Long getPrice() {
		return this.price;
	}
	public void setPrice(Long price) {
		this.price = price;
	}

	public Long getPriceUnit() {
		return this.priceUnit;
	}
	public void setPriceUnit(Long priceUnit) {
		this.priceUnit = priceUnit;
	}

	public String getPropertyList() {
		return this.propertyList;
	}
	public void setPropertyList(String propertyList) {
		this.propertyList = propertyList;
	}

	public String getProvinceList() {
		return this.provinceList;
	}
	public void setProvinceList(String provinceList) {
		this.provinceList = provinceList;
	}

	public Long getSaving() {
		return this.saving;
	}
	public void setSaving(Long saving) {
		this.saving = saving;
	}

	public String getSkuDetailList() {
		return this.skuDetailList;
	}
	public void setSkuDetailList(String skuDetailList) {
		this.skuDetailList = skuDetailList;
	}

	public String getSkuIdList() {
		return this.skuIdList;
	}
	public void setSkuIdList(String skuIdList) {
		this.skuIdList = skuIdList;
	}

	public String getSourceStatus() {
		return this.sourceStatus;
	}
	public void setSourceStatus(String sourceStatus) {
		this.sourceStatus = sourceStatus;
	}

	public String getSpuId() {
		return this.spuId;
	}
	public void setSpuId(String spuId) {
		this.spuId = spuId;
	}

	public Long getStockQuantity() {
		return this.stockQuantity;
	}
	public void setStockQuantity(Long stockQuantity) {
		this.stockQuantity = stockQuantity;
	}

	public Long getStockStatus() {
		return this.stockStatus;
	}
	public void setStockStatus(Long stockStatus) {
		this.stockStatus = stockStatus;
	}

	public Long getStuffStatus() {
		return this.stuffStatus;
	}
	public void setStuffStatus(Long stuffStatus) {
		this.stuffStatus = stuffStatus;
	}

	public String getSubTitle() {
		return this.subTitle;
	}
	public void setSubTitle(String subTitle) {
		this.subTitle = subTitle;
	}

	public String getTagList() {
		return this.tagList;
	}
	public void setTagList(String tagList) {
		this.tagList = tagList;
	}

	public String getTargetUrlAndroidApp() {
		return this.targetUrlAndroidApp;
	}
	public void setTargetUrlAndroidApp(String targetUrlAndroidApp) {
		this.targetUrlAndroidApp = targetUrlAndroidApp;
	}

	public String getTargetUrlCommon() {
		return this.targetUrlCommon;
	}
	public void setTargetUrlCommon(String targetUrlCommon) {
		this.targetUrlCommon = targetUrlCommon;
	}

	public String getTargetUrlH5() {
		return this.targetUrlH5;
	}
	public void setTargetUrlH5(String targetUrlH5) {
		this.targetUrlH5 = targetUrlH5;
	}

	public String getTargetUrlIosApp() {
		return this.targetUrlIosApp;
	}
	public void setTargetUrlIosApp(String targetUrlIosApp) {
		this.targetUrlIosApp = targetUrlIosApp;
	}

	public String getTargetUrlPc() {
		return this.targetUrlPc;
	}
	public void setTargetUrlPc(String targetUrlPc) {
		this.targetUrlPc = targetUrlPc;
	}

	public String getTargetUrlUniversalLink() {
		return this.targetUrlUniversalLink;
	}
	public void setTargetUrlUniversalLink(String targetUrlUniversalLink) {
		this.targetUrlUniversalLink = targetUrlUniversalLink;
	}

	public String getTitle() {
		return this.title;
	}
	public void setTitle(String title) {
		this.title = title;
	}

}
