package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 价格详情信息
 *
 * @author auto create
 * @since 1.0, 2022-11-12 15:44:43
 */
public class PriceInquiryDetailVO extends AlipayObject {

	private static final long serialVersionUID = 3168856615764741938L;

	/**
	 * 价格基础信息
	 */
	@ApiField("pricebaseinfo")
	private PriceBaseInfoVO pricebaseinfo;

	/**
	 * 价格费信息列表
	 */
	@ApiListField("pricefeeitemlist")
	@ApiField("price_fee_item_v_o")
	private List<PriceFeeItemVO> pricefeeitemlist;

	/**
	 * 费率描述
	 */
	@ApiListField("ratedesclist")
	@ApiField("fee_item_desc_v_o")
	private List<FeeItemDescVO> ratedesclist;

	public PriceBaseInfoVO getPricebaseinfo() {
		return this.pricebaseinfo;
	}
	public void setPricebaseinfo(PriceBaseInfoVO pricebaseinfo) {
		this.pricebaseinfo = pricebaseinfo;
	}

	public List<PriceFeeItemVO> getPricefeeitemlist() {
		return this.pricefeeitemlist;
	}
	public void setPricefeeitemlist(List<PriceFeeItemVO> pricefeeitemlist) {
		this.pricefeeitemlist = pricefeeitemlist;
	}

	public List<FeeItemDescVO> getRatedesclist() {
		return this.ratedesclist;
	}
	public void setRatedesclist(List<FeeItemDescVO> ratedesclist) {
		this.ratedesclist = ratedesclist;
	}

}
