package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 财务信息
 *
 * @author auto create
 * @since 1.0, 2022-11-12 15:52:57
 */
public class PriceFinanceInfoVO extends AlipayObject {

	private static final long serialVersionUID = 5568187146921244251L;

	/**
	 * 费用项ID
	 */
	@ApiField("feeitemid")
	private Long feeitemid;

	/**
	 * 费用对象
	 */
	@ApiField("feeobject")
	private PriceComponentVO feeobject;

	/**
	 * 是否签约指定推退费规则
	 */
	@ApiField("refundrulesetbysign")
	private Boolean refundrulesetbysign;

	/**
	 * 结算账户信息
	 */
	@ApiListField("settleaccount")
	@ApiField("merchant_account_info")
	private List<MerchantAccountInfo> settleaccount;

	/**
	 * 收费币种
	 */
	@ApiField("settlecurrency")
	private PriceComponentVO settlecurrency;

	/**
	 * 结算方式
	 */
	@ApiField("settletype")
	private PriceComponentVO settletype;

	public Long getFeeitemid() {
		return this.feeitemid;
	}
	public void setFeeitemid(Long feeitemid) {
		this.feeitemid = feeitemid;
	}

	public PriceComponentVO getFeeobject() {
		return this.feeobject;
	}
	public void setFeeobject(PriceComponentVO feeobject) {
		this.feeobject = feeobject;
	}

	public Boolean getRefundrulesetbysign() {
		return this.refundrulesetbysign;
	}
	public void setRefundrulesetbysign(Boolean refundrulesetbysign) {
		this.refundrulesetbysign = refundrulesetbysign;
	}

	public List<MerchantAccountInfo> getSettleaccount() {
		return this.settleaccount;
	}
	public void setSettleaccount(List<MerchantAccountInfo> settleaccount) {
		this.settleaccount = settleaccount;
	}

	public PriceComponentVO getSettlecurrency() {
		return this.settlecurrency;
	}
	public void setSettlecurrency(PriceComponentVO settlecurrency) {
		this.settlecurrency = settlecurrency;
	}

	public PriceComponentVO getSettletype() {
		return this.settletype;
	}
	public void setSettletype(PriceComponentVO settletype) {
		this.settletype = settletype;
	}

}
