package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 价格费信息
 *
 * @author auto create
 * @since 1.0, 2022-11-12 15:45:55
 */
public class PriceFeeItemVO extends AlipayObject {

	private static final long serialVersionUID = 4853817384485895539L;

	/**
	 * 退收费规则
	 */
	@ApiListField("chargerulelist")
	@ApiField("charge_rule_v_o")
	private List<ChargeRuleVO> chargerulelist;

	/**
	 * 费率组信息
	 */
	@ApiListField("feeinfolist")
	@ApiField("fee_info_v_o")
	private List<FeeInfoVO> feeinfolist;

	/**
	 * 费用项code
	 */
	@ApiField("feeitemcode")
	private String feeitemcode;

	/**
	 * 费用项ID
	 */
	@ApiField("feeitemid")
	private Long feeitemid;

	/**
	 * 费用项名称
	 */
	@ApiField("feeitemname")
	private String feeitemname;

	/**
	 * 财务信息
	 */
	@ApiField("pricefnanceinfo")
	private PriceFinanceInfoVO pricefnanceinfo;

	public List<ChargeRuleVO> getChargerulelist() {
		return this.chargerulelist;
	}
	public void setChargerulelist(List<ChargeRuleVO> chargerulelist) {
		this.chargerulelist = chargerulelist;
	}

	public List<FeeInfoVO> getFeeinfolist() {
		return this.feeinfolist;
	}
	public void setFeeinfolist(List<FeeInfoVO> feeinfolist) {
		this.feeinfolist = feeinfolist;
	}

	public String getFeeitemcode() {
		return this.feeitemcode;
	}
	public void setFeeitemcode(String feeitemcode) {
		this.feeitemcode = feeitemcode;
	}

	public Long getFeeitemid() {
		return this.feeitemid;
	}
	public void setFeeitemid(Long feeitemid) {
		this.feeitemid = feeitemid;
	}

	public String getFeeitemname() {
		return this.feeitemname;
	}
	public void setFeeitemname(String feeitemname) {
		this.feeitemname = feeitemname;
	}

	public PriceFinanceInfoVO getPricefnanceinfo() {
		return this.pricefnanceinfo;
	}
	public void setPricefnanceinfo(PriceFinanceInfoVO pricefnanceinfo) {
		this.pricefnanceinfo = pricefnanceinfo;
	}

}
