package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 费率约束
 *
 * @author auto create
 * @since 1.0, 2022-11-12 16:10:21
 */
public class PriceConditionInfoVO extends AlipayObject {

	private static final long serialVersionUID = 7218156119431184258L;

	/**
	 * 条件code
	 */
	@ApiField("conditioncode")
	private String conditioncode;

	/**
	 * 条件名称
	 */
	@ApiField("conditionname")
	private String conditionname;

	/**
	 * 来源方关联的code
	 */
	@ApiField("sourcecode")
	private String sourcecode;

	/**
	 * 条件值code列表 case:[BL,PP,PT,NOT_FILL]
	 */
	@ApiListField("valuecodelist")
	@ApiField("string")
	private List<String> valuecodelist;

	/**
	 * 值列表 case:[BL:余额,PP:花呗,PT:花呗分期,NOT_FILL:其他]
	 */
	@ApiField("valuelist")
	private Map valuelist;

	/**
	 * 条件值名称列表 case:[余额,花呗,花呗分期,其他]
	 */
	@ApiListField("valuetextlist")
	@ApiField("string")
	private List<String> valuetextlist;

	public String getConditioncode() {
		return this.conditioncode;
	}
	public void setConditioncode(String conditioncode) {
		this.conditioncode = conditioncode;
	}

	public String getConditionname() {
		return this.conditionname;
	}
	public void setConditionname(String conditionname) {
		this.conditionname = conditionname;
	}

	public String getSourcecode() {
		return this.sourcecode;
	}
	public void setSourcecode(String sourcecode) {
		this.sourcecode = sourcecode;
	}

	public List<String> getValuecodelist() {
		return this.valuecodelist;
	}
	public void setValuecodelist(List<String> valuecodelist) {
		this.valuecodelist = valuecodelist;
	}

	public Map getValuelist() {
		return this.valuelist;
	}
	public void setValuelist(Map valuelist) {
		this.valuelist = valuelist;
	}

	public List<String> getValuetextlist() {
		return this.valuetextlist;
	}
	public void setValuetextlist(List<String> valuetextlist) {
		this.valuetextlist = valuetextlist;
	}

}
