package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 开票信息
 *
 * @author auto create
 * @since 1.0, 2023-07-05 23:52:17
 */
public class PoBillableInfoDto extends AlipayObject {

	private static final long serialVersionUID = 5562198379615442467L;

	/**
	 * 清单列表
	 */
	@ApiListField("billable_info_details")
	@ApiField("billable_info_detail_dto")
	private List<BillableInfoDetailDto> billableInfoDetails;

	/**
	 * 是否海外
	 */
	@ApiField("is_abroad")
	private Boolean isAbroad;

	/**
	 * 是否当前采购人
	 */
	@ApiField("is_current_buyer")
	private Boolean isCurrentBuyer;

	/**
	 * 采购订单编号
	 */
	@ApiField("po_no")
	private String poNo;

	/**
	 * 收件人信息
	 */
	@ApiField("receive_info")
	private ReceiveInfoDto receiveInfo;

	public List<BillableInfoDetailDto> getBillableInfoDetails() {
		return this.billableInfoDetails;
	}
	public void setBillableInfoDetails(List<BillableInfoDetailDto> billableInfoDetails) {
		this.billableInfoDetails = billableInfoDetails;
	}

	public Boolean getIsAbroad() {
		return this.isAbroad;
	}
	public void setIsAbroad(Boolean isAbroad) {
		this.isAbroad = isAbroad;
	}

	public Boolean getIsCurrentBuyer() {
		return this.isCurrentBuyer;
	}
	public void setIsCurrentBuyer(Boolean isCurrentBuyer) {
		this.isCurrentBuyer = isCurrentBuyer;
	}

	public String getPoNo() {
		return this.poNo;
	}
	public void setPoNo(String poNo) {
		this.poNo = poNo;
	}

	public ReceiveInfoDto getReceiveInfo() {
		return this.receiveInfo;
	}
	public void setReceiveInfo(ReceiveInfoDto receiveInfo) {
		this.receiveInfo = receiveInfo;
	}

}
