package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * Payer information. See User for details.
 *
 * @author auto create
 * @since 1.0, 2021-08-16 15:53:01
 */
public class Payer extends AlipayObject {

	private static final long serialVersionUID = 5573196691442468788L;

	/**
	 * Date of birth
	 */
	@ApiField("birth_date")
	private String birthDate;

	/**
	 * 证件类型
	 */
	@ApiField("certificate")
	private Certificate certificate;

	/**
	 * The two-character ISO 3166 country/region code
	 */
	@ApiField("nationality")
	private String nationality;

	/**
	 * 用户地址
	 */
	@ApiField("user_address")
	private OperationAddress userAddress;

	/**
	 * A unique identifier of the user.
	 */
	@ApiField("user_id")
	private String userId;

	/**
	 * User name
	 */
	@ApiField("user_name")
	private UserName userName;

	public String getBirthDate() {
		return this.birthDate;
	}
	public void setBirthDate(String birthDate) {
		this.birthDate = birthDate;
	}

	public Certificate getCertificate() {
		return this.certificate;
	}
	public void setCertificate(Certificate certificate) {
		this.certificate = certificate;
	}

	public String getNationality() {
		return this.nationality;
	}
	public void setNationality(String nationality) {
		this.nationality = nationality;
	}

	public OperationAddress getUserAddress() {
		return this.userAddress;
	}
	public void setUserAddress(OperationAddress userAddress) {
		this.userAddress = userAddress;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

	public UserName getUserName() {
		return this.userName;
	}
	public void setUserName(UserName userName) {
		this.userName = userName;
	}

}
