package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 分账信息
 *
 * @author auto create
 * @since 1.0, 2023-03-02 18:53:59
 */
public class PayShareVO extends AlipayObject {

	private static final long serialVersionUID = 1372155991771733224L;

	/**
	 * 分账收款方外部会员ID（分账收款方为会员时必填）
	 */
	@ApiField("out_payee_id")
	private ReferenceId outPayeeId;

	/**
	 * 分账收款方账户
	 */
	@ApiField("payee_account")
	private AccountDTO payeeAccount;

	/**
	 * 分账金额
	 */
	@ApiField("share_amount")
	private String shareAmount;

	/**
	 * 分账金额单位
	 */
	@ApiField("share_currency")
	private String shareCurrency;

	public ReferenceId getOutPayeeId() {
		return this.outPayeeId;
	}
	public void setOutPayeeId(ReferenceId outPayeeId) {
		this.outPayeeId = outPayeeId;
	}

	public AccountDTO getPayeeAccount() {
		return this.payeeAccount;
	}
	public void setPayeeAccount(AccountDTO payeeAccount) {
		this.payeeAccount = payeeAccount;
	}

	public String getShareAmount() {
		return this.shareAmount;
	}
	public void setShareAmount(String shareAmount) {
		this.shareAmount = shareAmount;
	}

	public String getShareCurrency() {
		return this.shareCurrency;
	}
	public void setShareCurrency(String shareCurrency) {
		this.shareCurrency = shareCurrency;
	}

}
