package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 支付资产信息，用户创建支付时商户指定使用
 *
 * @author auto create
 * @since 1.0, 2022-09-05 10:52:00
 */
public class PayAsset extends AlipayObject {

	private static final long serialVersionUID = 4473575133672677738L;

	/**
	 * 当资产为银行卡类资产时，可以通过指定机构来选择不同的银行
	 */
	@ApiField("asset_inst")
	private String assetInst;

	/**
	 * 支持指定的资产名称。如balance-余额
	 */
	@ApiField("asset_name")
	private String assetName;

	public String getAssetInst() {
		return this.assetInst;
	}
	public void setAssetInst(String assetInst) {
		this.assetInst = assetInst;
	}

	public String getAssetName() {
		return this.assetName;
	}
	public void setAssetName(String assetName) {
		this.assetName = assetName;
	}

}
