package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 分页信息
 *
 * @author auto create
 * @since 1.0, 2020-06-25 12:19:15
 */
public class Pagination extends AlipayObject {

	private static final long serialVersionUID = 4186248553823255877L;

	/**
	 * 当前页
	 */
	@ApiField("current_page")
	private Long currentPage;

	/**
	 * 每页记录数
	 */
	@ApiField("record_per_page")
	private Long recordPerPage;

	/**
	 * 总页数
	 */
	@ApiField("total_page")
	private Long totalPage;

	/**
	 * 总记录数
	 */
	@ApiField("total_record")
	private Long totalRecord;

	public Long getCurrentPage() {
		return this.currentPage;
	}
	public void setCurrentPage(Long currentPage) {
		this.currentPage = currentPage;
	}

	public Long getRecordPerPage() {
		return this.recordPerPage;
	}
	public void setRecordPerPage(Long recordPerPage) {
		this.recordPerPage = recordPerPage;
	}

	public Long getTotalPage() {
		return this.totalPage;
	}
	public void setTotalPage(Long totalPage) {
		this.totalPage = totalPage;
	}

	public Long getTotalRecord() {
		return this.totalRecord;
	}
	public void setTotalRecord(Long totalRecord) {
		this.totalRecord = totalRecord;
	}

}
