package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 订单消息商品模型
 *
 * @author auto create
 * @since 1.0, 2023-05-23 22:18:19
 */
public class OrderGood extends AlipayObject {

	private static final long serialVersionUID = 6331431119792528525L;

	/**
	 * 支付宝商品skuId
	 */
	@ApiField("alipay_sku_id")
	private String alipaySkuId;

	/**
	 * 支付宝商品spuId
	 */
	@ApiField("alipay_spu_id")
	private String alipaySpuId;

	/**
	 * 商品描述
	 */
	@ApiField("desc")
	private String desc;

	/**
	 * 商品名称
	 */
	@ApiField("name")
	private String name;

	/**
	 * 商品图片
	 */
	@ApiField("picture_url")
	private String pictureUrl;

	/**
	 * 商品单价
	 */
	@ApiField("price")
	private String price;

	/**
	 * 商品数量
	 */
	@ApiField("quantity")
	private String quantity;

	/**
	 * 商户侧skuId
	 */
	@ApiField("sku_id")
	private String skuId;

	/**
	 * 商户侧spuId
	 */
	@ApiField("spu_id")
	private String spuId;

	public String getAlipaySkuId() {
		return this.alipaySkuId;
	}
	public void setAlipaySkuId(String alipaySkuId) {
		this.alipaySkuId = alipaySkuId;
	}

	public String getAlipaySpuId() {
		return this.alipaySpuId;
	}
	public void setAlipaySpuId(String alipaySpuId) {
		this.alipaySpuId = alipaySpuId;
	}

	public String getDesc() {
		return this.desc;
	}
	public void setDesc(String desc) {
		this.desc = desc;
	}

	public String getName() {
		return this.name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public String getPictureUrl() {
		return this.pictureUrl;
	}
	public void setPictureUrl(String pictureUrl) {
		this.pictureUrl = pictureUrl;
	}

	public String getPrice() {
		return this.price;
	}
	public void setPrice(String price) {
		this.price = price;
	}

	public String getQuantity() {
		return this.quantity;
	}
	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

	public String getSkuId() {
		return this.skuId;
	}
	public void setSkuId(String skuId) {
		this.skuId = skuId;
	}

	public String getSpuId() {
		return this.spuId;
	}
	public void setSpuId(String spuId) {
		this.spuId = spuId;
	}

}
