package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 兑换券详情
 *
 * @author auto create
 * @since 1.0, 2022-08-24 14:17:29
 */
public class OrderExchangeVoucher extends AlipayObject {

	private static final long serialVersionUID = 8112467484295198233L;

	/**
	 * 券的价值。
限制：币种为人名币，单位为元，小数点后最多保留两位。 
取值范围： [0.1, 3000]
	 */
	@ApiField("amount")
	private String amount;

	/**
	 * 优惠门槛金额，只有订单金额大于门槛金额时，券才能使用，该字段为空时表示无门槛。门槛金额由服务商（或商户）在核销时校验，支付宝只作展示。
限制：币种为人名币，单位为元，小数点后最多保留两位。 
取值范围： [0.1, 3000]
	 */
	@ApiField("floor_amount")
	private String floorAmount;

	/**
	 * 用户购买优惠券时需要支付的金额。
限制：币种为人名币，单位为元，小数点后最多保留两位。
取值范围： [0.1, 3000]
	 */
	@ApiField("sale_amount")
	private String saleAmount;

	public String getAmount() {
		return this.amount;
	}
	public void setAmount(String amount) {
		this.amount = amount;
	}

	public String getFloorAmount() {
		return this.floorAmount;
	}
	public void setFloorAmount(String floorAmount) {
		this.floorAmount = floorAmount;
	}

	public String getSaleAmount() {
		return this.saleAmount;
	}
	public void setSaleAmount(String saleAmount) {
		this.saleAmount = saleAmount;
	}

}
