package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 网商支付业务签约查询
 *
 * @author auto create
 * @since 1.0, 2023-02-07 16:25:16
 */
public class MybankPaymentAgreementQueryModel extends AlipayObject {

	private static final long serialVersionUID = 5325952126164667563L;

	/**
	 * 合约号，如果传了该参数，其他参数会被忽略
	 */
	@ApiField("agreement_no")
	private String agreementNo;

	/**
	 * 签约业务产品码，详情咨询开发小二
	 */
	@ApiField("product_code")
	private String productCode;

	/**
	 * 签约业务场景码，详情咨询开发小二
	 */
	@ApiField("scene_code")
	private String sceneCode;

	/**
	 * 签约用户的蚂蚁统一会员ID
	 */
	@ApiField("user_id")
	private String userId;

	public String getAgreementNo() {
		return this.agreementNo;
	}
	public void setAgreementNo(String agreementNo) {
		this.agreementNo = agreementNo;
	}

	public String getProductCode() {
		return this.productCode;
	}
	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

	public String getSceneCode() {
		return this.sceneCode;
	}
	public void setSceneCode(String sceneCode) {
		this.sceneCode = sceneCode;
	}

	public String getUserId() {
		return this.userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

}
