package com.alipay.api.domain;

import java.util.Date;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 支付宝信息授权签约
 *
 * @author auto create
 * @since 1.0, 2022-03-08 15:08:42
 */
public class MybankCreditUserAntdataAuthCreateModel extends AlipayObject {

	private static final long serialVersionUID = 7426396513637426818L;

	/**
	 * 支付宝ID
	 */
	@ApiField("alipay_user_id")
	private String alipayUserId;

	/**
	 * 签约授权产品码
	 */
	@ApiField("auth_prod_code")
	private String authProdCode;

	/**
	 * 请求Id
	 */
	@ApiField("request_id")
	private String requestId;

	/**
	 * 生效截止时间
	 */
	@ApiField("valid_end_date")
	private Date validEndDate;

	/**
	 * 生效开始时间
	 */
	@ApiField("valid_start_date")
	private Date validStartDate;

	public String getAlipayUserId() {
		return this.alipayUserId;
	}
	public void setAlipayUserId(String alipayUserId) {
		this.alipayUserId = alipayUserId;
	}

	public String getAuthProdCode() {
		return this.authProdCode;
	}
	public void setAuthProdCode(String authProdCode) {
		this.authProdCode = authProdCode;
	}

	public String getRequestId() {
		return this.requestId;
	}
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	public Date getValidEndDate() {
		return this.validEndDate;
	}
	public void setValidEndDate(Date validEndDate) {
		this.validEndDate = validEndDate;
	}

	public Date getValidStartDate() {
		return this.validStartDate;
	}
	public void setValidStartDate(Date validStartDate) {
		this.validStartDate = validStartDate;
	}

}
