package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 机构联合扣款网商扣款结果查询
 *
 * @author auto create
 * @since 1.0, 2022-08-26 14:52:23
 */
public class MybankCreditLoantradeRepayUniondeductresultQueryModel extends AlipayObject {

	private static final long serialVersionUID = 6446475278995618976L;

	/**
	 * 支付宝用户id
	 */
	@ApiField("alipay_user_id")
	private String alipayUserId;

	/**
	 * 网商侧返回的批次扣款事件单号
	 */
	@ApiField("ev_seq_no")
	private String evSeqNo;

	/**
	 * 机构角色id，线上线下不一致，上线前网商银行会分配，记得替换
	 */
	@ApiField("org_ip_role_id")
	private String orgIpRoleId;

	/**
	 * 请求幂等ID，标识一次业务交互，机构的ipRoleId+"_"+业务ID串 注意：机构接收到同一幂等ID的请求将忽略，机构的ipRoleId线上线下不一致，上线前网商银行会分配，记得替换。
	 */
	@ApiField("request_id")
	private String requestId;

	public String getAlipayUserId() {
		return this.alipayUserId;
	}
	public void setAlipayUserId(String alipayUserId) {
		this.alipayUserId = alipayUserId;
	}

	public String getEvSeqNo() {
		return this.evSeqNo;
	}
	public void setEvSeqNo(String evSeqNo) {
		this.evSeqNo = evSeqNo;
	}

	public String getOrgIpRoleId() {
		return this.orgIpRoleId;
	}
	public void setOrgIpRoleId(String orgIpRoleId) {
		this.orgIpRoleId = orgIpRoleId;
	}

	public String getRequestId() {
		return this.requestId;
	}
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

}
