package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 联合追款网商扣款申请接口
 *
 * @author auto create
 * @since 1.0, 2022-08-26 14:39:54
 */
public class MybankCreditLoantradeRepayUniondeductApplyModel extends AlipayObject {

	private static final long serialVersionUID = 6413318836466748291L;

	/**
	 * 机构网联批次转账总金额	
单位为元
类型为人民币
	 */
	@ApiField("inst_deduction_total_amt")
	private String instDeductionTotalAmt;

	/**
	 * 机构角色id，线上线下不一致，上线前网商银行会分配，记得替换
	 */
	@ApiField("org_ip_role_id")
	private String orgIpRoleId;

	/**
	 * 请求幂等ID，标识一次业务交互，机构的ipRoleId+"_"+业务ID串 注意：机构接收到同一幂等ID的请求将忽略，机构的ipRoleId线上线下不一致，上线前网商银行会分配，记得替换。
	 */
	@ApiField("request_id")
	private String requestId;

	/**
	 * 核销单号
	 */
	@ApiField("sheet_no")
	private String sheetNo;

	/**
	 * 客户扣款信息列表
	 */
	@ApiListField("user_deduct_list")
	@ApiField("user_deduct_info")
	private List<UserDeductInfo> userDeductList;

	public String getInstDeductionTotalAmt() {
		return this.instDeductionTotalAmt;
	}
	public void setInstDeductionTotalAmt(String instDeductionTotalAmt) {
		this.instDeductionTotalAmt = instDeductionTotalAmt;
	}

	public String getOrgIpRoleId() {
		return this.orgIpRoleId;
	}
	public void setOrgIpRoleId(String orgIpRoleId) {
		this.orgIpRoleId = orgIpRoleId;
	}

	public String getRequestId() {
		return this.requestId;
	}
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	public String getSheetNo() {
		return this.sheetNo;
	}
	public void setSheetNo(String sheetNo) {
		this.sheetNo = sheetNo;
	}

	public List<UserDeductInfo> getUserDeductList() {
		return this.userDeductList;
	}
	public void setUserDeductList(List<UserDeductInfo> userDeductList) {
		this.userDeductList = userDeductList;
	}

}
