package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 客户逾期贷款余额查询接口
 *
 * @author auto create
 * @since 1.0, 2022-08-26 14:13:47
 */
public class MybankCreditLoantradeRepayCustovdloanQueryModel extends AlipayObject {

	private static final long serialVersionUID = 3113851311137692931L;

	/**
	 * 支付宝用户id
	 */
	@ApiField("alipay_user_id")
	private String alipayUserId;

	/**
	 * 预留字段，json格式
	 */
	@ApiField("ext")
	private String ext;

	/**
	 * 机构角色id，线上线下不一致，上线前网商银行会分配，记得替换
	 */
	@ApiField("org_ip_role_id")
	private String orgIpRoleId;

	/**
	 * 逾期借据号列表
注：一次最多计算20笔借据
	 */
	@ApiListField("ovd_loan_nos")
	@ApiField("string")
	private List<String> ovdLoanNos;

	/**
	 * 请求幂等ID，标识一次业务交互，机构的ipRoleId+"_"+业务ID串 注意：机构接收到同一幂等ID的请求将忽略，机构的ipRoleId线上线下不一致，上线前网商银行会分配，记得替换。
	 */
	@ApiField("request_id")
	private String requestId;

	public String getAlipayUserId() {
		return this.alipayUserId;
	}
	public void setAlipayUserId(String alipayUserId) {
		this.alipayUserId = alipayUserId;
	}

	public String getExt() {
		return this.ext;
	}
	public void setExt(String ext) {
		this.ext = ext;
	}

	public String getOrgIpRoleId() {
		return this.orgIpRoleId;
	}
	public void setOrgIpRoleId(String orgIpRoleId) {
		this.orgIpRoleId = orgIpRoleId;
	}

	public List<String> getOvdLoanNos() {
		return this.ovdLoanNos;
	}
	public void setOvdLoanNos(List<String> ovdLoanNos) {
		this.ovdLoanNos = ovdLoanNos;
	}

	public String getRequestId() {
		return this.requestId;
	}
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

}
