package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 码上收子单信息
 *
 * @author auto create
 * @since 1.0, 2022-05-30 16:47:47
 */
public class MssOrderInfo extends AlipayObject {

	private static final long serialVersionUID = 8229587628193688269L;

	/**
	 * 商品id
	 */
	@ApiField("goods_id")
	private String goodsId;

	/**
	 * 码上收子单id
	 */
	@ApiField("order_id")
	private String orderId;

	/**
	 * 订单状态枚举值:
"WAIT_PAY","等待支付"; 
"PAID", "已支付" ;
"CANCEL_CLOSED"  "用户主动关闭";
"TIMEOUT_CLOSED" "支付超时";
 "REFUND_CLOSED" "系统/用户发起主动退款";
	 */
	@ApiField("order_status")
	private String orderStatus;

	/**
	 * 商品原价, 单位:元
	 */
	@ApiField("original_price")
	private String originalPrice;

	/**
	 * 商品数量
	 */
	@ApiField("quantity")
	private String quantity;

	/**
	 * 商品实付价格,单位:元
	 */
	@ApiField("real_price")
	private String realPrice;

	/**
	 * 商品skuId
	 */
	@ApiField("sku_id")
	private String skuId;

	/**
	 * 商品所属门店
	 */
	@ApiField("store_id")
	private String storeId;

	public String getGoodsId() {
		return this.goodsId;
	}
	public void setGoodsId(String goodsId) {
		this.goodsId = goodsId;
	}

	public String getOrderId() {
		return this.orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOrderStatus() {
		return this.orderStatus;
	}
	public void setOrderStatus(String orderStatus) {
		this.orderStatus = orderStatus;
	}

	public String getOriginalPrice() {
		return this.originalPrice;
	}
	public void setOriginalPrice(String originalPrice) {
		this.originalPrice = originalPrice;
	}

	public String getQuantity() {
		return this.quantity;
	}
	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

	public String getRealPrice() {
		return this.realPrice;
	}
	public void setRealPrice(String realPrice) {
		this.realPrice = realPrice;
	}

	public String getSkuId() {
		return this.skuId;
	}
	public void setSkuId(String skuId) {
		this.skuId = skuId;
	}

	public String getStoreId() {
		return this.storeId;
	}
	public void setStoreId(String storeId) {
		this.storeId = storeId;
	}

}
