package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * dataphin逻辑模型
 *
 * @author auto create
 * @since 1.0, 2021-09-08 15:29:45
 */
public class ModelDTO extends AlipayObject {

	private static final long serialVersionUID = 5462883476923779936L;

	/**
	 * 逻辑模型中文名
	 */
	@ApiField("cn")
	private String cn;

	/**
	 * 度量字段
	 */
	@ApiListField("measures")
	@ApiField("attribute_d_t_o")
	private List<AttributeDTO> measures;

	/**
	 * 来源模型名称
	 */
	@ApiField("name")
	private String name;

	/**
	 * 普通字段
	 */
	@ApiListField("normals")
	@ApiField("attribute_d_t_o")
	private List<AttributeDTO> normals;

	/**
	 * 分区字段
	 */
	@ApiListField("partition")
	@ApiField("attribute_d_t_o")
	private List<AttributeDTO> partition;

	public String getCn() {
		return this.cn;
	}
	public void setCn(String cn) {
		this.cn = cn;
	}

	public List<AttributeDTO> getMeasures() {
		return this.measures;
	}
	public void setMeasures(List<AttributeDTO> measures) {
		this.measures = measures;
	}

	public String getName() {
		return this.name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public List<AttributeDTO> getNormals() {
		return this.normals;
	}
	public void setNormals(List<AttributeDTO> normals) {
		this.normals = normals;
	}

	public List<AttributeDTO> getPartition() {
		return this.partition;
	}
	public void setPartition(List<AttributeDTO> partition) {
		this.partition = partition;
	}

}
