package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 结算账户信息
 *
 * @author auto create
 * @since 1.0, 2022-11-12 15:59:49
 */
public class MerchantAccountInfo extends AlipayObject {

	private static final long serialVersionUID = 2464391594176996637L;

	/**
	 * 账户，如果没有的话不能用来作为结算账号
	 */
	@ApiField("accountno")
	private String accountno;

	/**
	 * cardNo
	 */
	@ApiField("cardno")
	private String cardno;

	/**
	 * cid
	 */
	@ApiField("cid")
	private String cid;

	/**
	 * 机构, 如果是INST，可以没有accountNo
	 */
	@ApiField("cidtype")
	private String cidtype;

	/**
	 * 登陆id
	 */
	@ApiField("logonid")
	private String logonid;

	/**
	 * pid
	 */
	@ApiField("partnerid")
	private String partnerid;

	public String getAccountno() {
		return this.accountno;
	}
	public void setAccountno(String accountno) {
		this.accountno = accountno;
	}

	public String getCardno() {
		return this.cardno;
	}
	public void setCardno(String cardno) {
		this.cardno = cardno;
	}

	public String getCid() {
		return this.cid;
	}
	public void setCid(String cid) {
		this.cid = cid;
	}

	public String getCidtype() {
		return this.cidtype;
	}
	public void setCidtype(String cidtype) {
		this.cidtype = cidtype;
	}

	public String getLogonid() {
		return this.logonid;
	}
	public void setLogonid(String logonid) {
		this.logonid = logonid;
	}

	public String getPartnerid() {
		return this.partnerid;
	}
	public void setPartnerid(String partnerid) {
		this.partnerid = partnerid;
	}

}
