package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 客户实际合约信息明细
 *
 * @author auto create
 * @since 1.0, 2022-08-26 10:39:53
 */
public class LoanInfoVO extends AlipayObject {

	private static final long serialVersionUID = 3839242557995499423L;

	/**
	 * 逾期借据编号
	 */
	@ApiField("loan_no")
	private String loanNo;

	/**
	 * 贷款合约状态：
NORMAL-正常，OVD-逾期，CLEAR-结清
	 */
	@ApiField("loan_status")
	private String loanStatus;

	/**
	 * 逾期金额
单位为元
类型为人民币
	 */
	@ApiField("ovd_amt")
	private String ovdAmt;

	/**
	 * 逾期天数
	 */
	@ApiField("ovd_days")
	private Long ovdDays;

	public String getLoanNo() {
		return this.loanNo;
	}
	public void setLoanNo(String loanNo) {
		this.loanNo = loanNo;
	}

	public String getLoanStatus() {
		return this.loanStatus;
	}
	public void setLoanStatus(String loanStatus) {
		this.loanStatus = loanStatus;
	}

	public String getOvdAmt() {
		return this.ovdAmt;
	}
	public void setOvdAmt(String ovdAmt) {
		this.ovdAmt = ovdAmt;
	}

	public Long getOvdDays() {
		return this.ovdDays;
	}
	public void setOvdDays(Long ovdDays) {
		this.ovdDays = ovdDays;
	}

}
