package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 开票请求请求结果
 *
 * @author auto create
 * @since 1.0, 2020-06-10 12:14:49
 */
public class InvoiceCreateResultDTO extends AlipayObject {

	private static final long serialVersionUID = 5248262114289676415L;

	/**
	 * 中台处理之后的真实开票请求。预处理（价税分离与拆单）、或匹配编码规则、或填充销方信息之后的结果。 当auto_preprocess=true, 会返回多笔真实开票请求，当auto_preprocess=false,不会返回该字段，请忽略下面的字段。
	 */
	@ApiListField("invoice_create_reqs")
	@ApiField("invoice_create_req_d_t_o")
	private List<InvoiceCreateReqDTO> invoiceCreateReqs;

	/**
	 * 开票流水号/序列号，唯一标志一笔开票请求。发票中台生成，用于查询开票结果。 当auto_preprocess=true,预处理之后可能生成多笔开票请求，此处可能返回多个序列号。多个序列号之间英文逗号(半角)分隔。 当auto_preprocess=false,只会返回一个序列号。
	 */
	@ApiField("serial_no")
	private String serialNo;

	public List<InvoiceCreateReqDTO> getInvoiceCreateReqs() {
		return this.invoiceCreateReqs;
	}
	public void setInvoiceCreateReqs(List<InvoiceCreateReqDTO> invoiceCreateReqs) {
		this.invoiceCreateReqs = invoiceCreateReqs;
	}

	public String getSerialNo() {
		return this.serialNo;
	}
	public void setSerialNo(String serialNo) {
		this.serialNo = serialNo;
	}

}
