package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 发票开票请求
 *
 * @author auto create
 * @since 1.0, 2020-06-10 11:49:14
 */
public class InvoiceCreateDTO extends AlipayObject {

	private static final long serialVersionUID = 8367552261169844487L;

	/**
	 * 是否自动填充企业信息，true: 中台查询销方信息后自动填充（字段为null时才会填充），以“payee_”开头的字段。 false: 中台不填充，由业务前台传入。 默认false
	 */
	@ApiField("auto_fill_payee_info")
	private Boolean autoFillPayeeInfo;

	/**
	 * 是否自动匹配税编规则，ture是，false否。默认false。 为ture时中台会自动匹配由商户维护的商品税编规则，自动读取税收分类编码和税率
	 */
	@ApiField("auto_matching_taxcode")
	private Boolean autoMatchingTaxcode;

	/**
	 * 是否自动预处理（价税分离与拆单）。 true 是，false 否。默认false。 为true时中台会自动计算含税金额，不含税金额，税额。 并且根据企业限额将当前开票请求拆分为多个开票请求。
	 */
	@ApiField("auto_preprocess")
	private Boolean autoPreprocess;

	/**
	 * 抬头类型。可选值： 0：个人 1：企业
	 */
	@ApiField("business_type")
	private Long businessType;

	/**
	 * ERP系统中的单据号。如果没有erp的唯一单据号。建议使用platform_code+”_”+ platform_tid的组合方式
	 */
	@ApiField("erp_tid")
	private String erpTid;

	/**
	 * 原子粒度控制：是否忽略拆单，可以由外部指定。适用于 前台不需要拆单，但需要其他预处理能力的场景。
	 */
	@ApiField("ignore_split_order")
	private Boolean ignoreSplitOrder;

	/**
	 * 合计含税金额（开票金额），当开红票时，该字段为负数。auto_cal_tax=true时，与sum_price不能同时为空。 auto_cal_tax=false时均必填。当auto_preprocess=true 不可同时为空，且必须和明细成对出现。当auto_preprocess=false全部必填
	 */
	@ApiField("invoice_amount")
	private String invoiceAmount;

	/**
	 * 发票明细列表
	 */
	@ApiListField("invoice_items")
	@ApiField("invoice_item_data")
	private List<InvoiceItemData> invoiceItems;

	/**
	 * 开票发票类型 可选值： 0: 电票 1：纸质普票 2：纸质专票
	 */
	@ApiField("invoice_kind")
	private Long invoiceKind;

	/**
	 * 发票备注，会显示在票面
	 */
	@ApiField("invoice_memo")
	private String invoiceMemo;

	/**
	 * 发票(开票)类型，可选值：蓝票blue, 红票red
	 */
	@ApiField("invoice_type")
	private String invoiceType;

	/**
	 * 征税方式，0普通征收，1减按征收，2差额征收
	 */
	@ApiField("levy_type")
	private Long levyType;

	/**
	 * 原发票代码(开红票时必须)
	 */
	@ApiField("normal_invoice_code")
	private String normalInvoiceCode;

	/**
	 * 原发票号码(开红票时必须)
	 */
	@ApiField("normal_invoice_no")
	private String normalInvoiceNo;

	/**
	 * 请求的唯一标志，请求幂等ID，由调用平台生
	 */
	@ApiField("outer_id")
	private String outerId;

	/**
	 * 销方地址 auto_fill_payee_info=false时必填
	 */
	@ApiField("payee_address")
	private String payeeAddress;

	/**
	 * 销方银行帐号 auto_fill_payee_info=false时必填
	 */
	@ApiField("payee_bank_account_id")
	private String payeeBankAccountId;

	/**
	 * 销方开户行名称，开户行账号加名称不超出100字符auto_fill_payee_info=false时必填
	 */
	@ApiField("payee_bank_name")
	private String payeeBankName;

	/**
	 * 复核人
	 */
	@ApiField("payee_checker")
	private String payeeChecker;

	/**
	 * 开票方名称，公司名(如:XX商城) auto_fill_payee_info=false时必填
	 */
	@ApiField("payee_name")
	private String payeeName;

	/**
	 * 开票人 auto_fill_payee_info=false时必填
	 */
	@ApiField("payee_operator")
	private String payeeOperator;

	/**
	 * 销方电话 auto_fill_payee_info=false时必填
	 */
	@ApiField("payee_phone")
	private String payeePhone;

	/**
	 * 收款人
	 */
	@ApiField("payee_receiver")
	private String payeeReceiver;

	/**
	 * 销方税务登记证号
	 */
	@ApiField("payee_register_no")
	private String payeeRegisterNo;

	/**
	 * 购方地址
	 */
	@ApiField("payer_address")
	private String payerAddress;

	/**
	 * 购方银行账号
	 */
	@ApiField("payer_bank_account_id")
	private String payerBankAccountId;

	/**
	 * 购方开户行名称，开户行账号加名称不超出100字符
	 */
	@ApiField("payer_bank_name")
	private String payerBankName;

	/**
	 * 购方电子邮箱
	 */
	@ApiField("payer_email")
	private String payerEmail;

	/**
	 * 购方抬头
	 */
	@ApiField("payer_name")
	private String payerName;

	/**
	 * 购方联系电话
	 */
	@ApiField("payer_phone")
	private String payerPhone;

	/**
	 * 购方方税务登记证号。 开企业抬头时必填。
	 */
	@ApiField("payer_register_no")
	private String payerRegisterNo;

	/**
	 * 业务平台code, 由发票中台分配
	 */
	@ApiField("platform_code")
	private String platformCode;

	/**
	 * 业务平台对应的订单号
	 */
	@ApiField("platform_tid")
	private String platformTid;

	/**
	 * 业务平台商户ID/卖家用户ID，用于归集发票
	 */
	@ApiField("platform_user_id")
	private String platformUserId;

	/**
	 * 税控产品Code，由中台定义的产品码
	 */
	@ApiField("product_code")
	private String productCode;

	/**
	 * 特殊票种标识，可选值： 02: 农产品收购票
	 */
	@ApiField("special_flag")
	private String specialFlag;

	/**
	 * 合计金额，当开红票时，该字段为负数。auto_cal_tax=true时，不能同时为空。 auto_cal_tax=false时与invoice_amount均必填。当auto_preprocess=true 不可同时为空，且必须和明细成对出现。当auto_preprocess=false全部必填
	 */
	@ApiField("sum_price")
	private String sumPrice;

	/**
	 * 合计税额，格式为2位小数。 当开红票时，该字段为负数。当auto_preprocess=true勿传，由中台自动计算。当auto_preprocess=false必填
	 */
	@ApiField("sum_tax")
	private String sumTax;

	/**
	 * 入驻商户税控盘未托管的开票链路，此参数必传。 云化税控可不填
	 */
	@ApiField("tax_token")
	private String taxToken;

	public Boolean getAutoFillPayeeInfo() {
		return this.autoFillPayeeInfo;
	}
	public void setAutoFillPayeeInfo(Boolean autoFillPayeeInfo) {
		this.autoFillPayeeInfo = autoFillPayeeInfo;
	}

	public Boolean getAutoMatchingTaxcode() {
		return this.autoMatchingTaxcode;
	}
	public void setAutoMatchingTaxcode(Boolean autoMatchingTaxcode) {
		this.autoMatchingTaxcode = autoMatchingTaxcode;
	}

	public Boolean getAutoPreprocess() {
		return this.autoPreprocess;
	}
	public void setAutoPreprocess(Boolean autoPreprocess) {
		this.autoPreprocess = autoPreprocess;
	}

	public Long getBusinessType() {
		return this.businessType;
	}
	public void setBusinessType(Long businessType) {
		this.businessType = businessType;
	}

	public String getErpTid() {
		return this.erpTid;
	}
	public void setErpTid(String erpTid) {
		this.erpTid = erpTid;
	}

	public Boolean getIgnoreSplitOrder() {
		return this.ignoreSplitOrder;
	}
	public void setIgnoreSplitOrder(Boolean ignoreSplitOrder) {
		this.ignoreSplitOrder = ignoreSplitOrder;
	}

	public String getInvoiceAmount() {
		return this.invoiceAmount;
	}
	public void setInvoiceAmount(String invoiceAmount) {
		this.invoiceAmount = invoiceAmount;
	}

	public List<InvoiceItemData> getInvoiceItems() {
		return this.invoiceItems;
	}
	public void setInvoiceItems(List<InvoiceItemData> invoiceItems) {
		this.invoiceItems = invoiceItems;
	}

	public Long getInvoiceKind() {
		return this.invoiceKind;
	}
	public void setInvoiceKind(Long invoiceKind) {
		this.invoiceKind = invoiceKind;
	}

	public String getInvoiceMemo() {
		return this.invoiceMemo;
	}
	public void setInvoiceMemo(String invoiceMemo) {
		this.invoiceMemo = invoiceMemo;
	}

	public String getInvoiceType() {
		return this.invoiceType;
	}
	public void setInvoiceType(String invoiceType) {
		this.invoiceType = invoiceType;
	}

	public Long getLevyType() {
		return this.levyType;
	}
	public void setLevyType(Long levyType) {
		this.levyType = levyType;
	}

	public String getNormalInvoiceCode() {
		return this.normalInvoiceCode;
	}
	public void setNormalInvoiceCode(String normalInvoiceCode) {
		this.normalInvoiceCode = normalInvoiceCode;
	}

	public String getNormalInvoiceNo() {
		return this.normalInvoiceNo;
	}
	public void setNormalInvoiceNo(String normalInvoiceNo) {
		this.normalInvoiceNo = normalInvoiceNo;
	}

	public String getOuterId() {
		return this.outerId;
	}
	public void setOuterId(String outerId) {
		this.outerId = outerId;
	}

	public String getPayeeAddress() {
		return this.payeeAddress;
	}
	public void setPayeeAddress(String payeeAddress) {
		this.payeeAddress = payeeAddress;
	}

	public String getPayeeBankAccountId() {
		return this.payeeBankAccountId;
	}
	public void setPayeeBankAccountId(String payeeBankAccountId) {
		this.payeeBankAccountId = payeeBankAccountId;
	}

	public String getPayeeBankName() {
		return this.payeeBankName;
	}
	public void setPayeeBankName(String payeeBankName) {
		this.payeeBankName = payeeBankName;
	}

	public String getPayeeChecker() {
		return this.payeeChecker;
	}
	public void setPayeeChecker(String payeeChecker) {
		this.payeeChecker = payeeChecker;
	}

	public String getPayeeName() {
		return this.payeeName;
	}
	public void setPayeeName(String payeeName) {
		this.payeeName = payeeName;
	}

	public String getPayeeOperator() {
		return this.payeeOperator;
	}
	public void setPayeeOperator(String payeeOperator) {
		this.payeeOperator = payeeOperator;
	}

	public String getPayeePhone() {
		return this.payeePhone;
	}
	public void setPayeePhone(String payeePhone) {
		this.payeePhone = payeePhone;
	}

	public String getPayeeReceiver() {
		return this.payeeReceiver;
	}
	public void setPayeeReceiver(String payeeReceiver) {
		this.payeeReceiver = payeeReceiver;
	}

	public String getPayeeRegisterNo() {
		return this.payeeRegisterNo;
	}
	public void setPayeeRegisterNo(String payeeRegisterNo) {
		this.payeeRegisterNo = payeeRegisterNo;
	}

	public String getPayerAddress() {
		return this.payerAddress;
	}
	public void setPayerAddress(String payerAddress) {
		this.payerAddress = payerAddress;
	}

	public String getPayerBankAccountId() {
		return this.payerBankAccountId;
	}
	public void setPayerBankAccountId(String payerBankAccountId) {
		this.payerBankAccountId = payerBankAccountId;
	}

	public String getPayerBankName() {
		return this.payerBankName;
	}
	public void setPayerBankName(String payerBankName) {
		this.payerBankName = payerBankName;
	}

	public String getPayerEmail() {
		return this.payerEmail;
	}
	public void setPayerEmail(String payerEmail) {
		this.payerEmail = payerEmail;
	}

	public String getPayerName() {
		return this.payerName;
	}
	public void setPayerName(String payerName) {
		this.payerName = payerName;
	}

	public String getPayerPhone() {
		return this.payerPhone;
	}
	public void setPayerPhone(String payerPhone) {
		this.payerPhone = payerPhone;
	}

	public String getPayerRegisterNo() {
		return this.payerRegisterNo;
	}
	public void setPayerRegisterNo(String payerRegisterNo) {
		this.payerRegisterNo = payerRegisterNo;
	}

	public String getPlatformCode() {
		return this.platformCode;
	}
	public void setPlatformCode(String platformCode) {
		this.platformCode = platformCode;
	}

	public String getPlatformTid() {
		return this.platformTid;
	}
	public void setPlatformTid(String platformTid) {
		this.platformTid = platformTid;
	}

	public String getPlatformUserId() {
		return this.platformUserId;
	}
	public void setPlatformUserId(String platformUserId) {
		this.platformUserId = platformUserId;
	}

	public String getProductCode() {
		return this.productCode;
	}
	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

	public String getSpecialFlag() {
		return this.specialFlag;
	}
	public void setSpecialFlag(String specialFlag) {
		this.specialFlag = specialFlag;
	}

	public String getSumPrice() {
		return this.sumPrice;
	}
	public void setSumPrice(String sumPrice) {
		this.sumPrice = sumPrice;
	}

	public String getSumTax() {
		return this.sumTax;
	}
	public void setSumTax(String sumTax) {
		this.sumTax = sumTax;
	}

	public String getTaxToken() {
		return this.taxToken;
	}
	public void setTaxToken(String taxToken) {
		this.taxToken = taxToken;
	}

}
