package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 保单的返回信息
 *
 * @author auto create
 * @since 1.0, 2021-09-13 15:42:02
 */
public class InsPolicyByInsuredPerson extends AlipayObject {

	private static final long serialVersionUID = 5485531986223799626L;

	/**
	 * 保单邮寄地址
	 */
	@ApiField("addressee")
	private InsAddressee addressee;

	/**
	 * 险种列表
	 */
	@ApiListField("coverages")
	@ApiField("ins_coverage")
	private List<InsCoverage> coverages;

	/**
	 * 保单失效时间
	 */
	@ApiField("effect_end_time")
	private String effectEndTime;

	/**
	 * 保单生效时间
	 */
	@ApiField("effect_start_time")
	private String effectStartTime;

	/**
	 * 机构产品编号
	 */
	@ApiField("item_id")
	private String itemId;

	/**
	 * 机构名称
	 */
	@ApiField("merchant_name")
	private String merchantName;

	/**
	 * 外部保单号
	 */
	@ApiField("out_policy_no")
	private String outPolicyNo;

	/**
	 * 终缴时间，用于健康险、寿险等场景，用户需要按期缴费使用
	 */
	@ApiField("pay_end_time")
	private String payEndTime;

	/**
	 * 缴至时间，用于健康险、寿险等场景，用户需要按期缴费使用
	 */
	@ApiField("pay_to_time")
	private Date payToTime;

	/**
	 * 保单凭证号;蚂蚁保险平台生成的保单凭证号,用户可以通过此单号去保险公司查询保单信息.
	 */
	@ApiField("policy_no")
	private String policyNo;

	/**
	 * 保单：分
	 */
	@ApiField("premium")
	private Long premium;

	/**
	 * 产品名称
	 */
	@ApiField("prod_name")
	private String prodName;

	/**
	 * 标准产品编号
	 */
	@ApiField("sp_no")
	private String spNo;

	/**
	 * 保额 ;单位分
	 */
	@ApiField("sum_insured")
	private Long sumInsured;

	/**
	 * 退保金额
	 */
	@ApiField("surrender_fee")
	private Long surrenderFee;

	/**
	 * 退保时间
	 */
	@ApiField("surrender_time")
	private Date surrenderTime;

	public InsAddressee getAddressee() {
		return this.addressee;
	}
	public void setAddressee(InsAddressee addressee) {
		this.addressee = addressee;
	}

	public List<InsCoverage> getCoverages() {
		return this.coverages;
	}
	public void setCoverages(List<InsCoverage> coverages) {
		this.coverages = coverages;
	}

	public String getEffectEndTime() {
		return this.effectEndTime;
	}
	public void setEffectEndTime(String effectEndTime) {
		this.effectEndTime = effectEndTime;
	}

	public String getEffectStartTime() {
		return this.effectStartTime;
	}
	public void setEffectStartTime(String effectStartTime) {
		this.effectStartTime = effectStartTime;
	}

	public String getItemId() {
		return this.itemId;
	}
	public void setItemId(String itemId) {
		this.itemId = itemId;
	}

	public String getMerchantName() {
		return this.merchantName;
	}
	public void setMerchantName(String merchantName) {
		this.merchantName = merchantName;
	}

	public String getOutPolicyNo() {
		return this.outPolicyNo;
	}
	public void setOutPolicyNo(String outPolicyNo) {
		this.outPolicyNo = outPolicyNo;
	}

	public String getPayEndTime() {
		return this.payEndTime;
	}
	public void setPayEndTime(String payEndTime) {
		this.payEndTime = payEndTime;
	}

	public Date getPayToTime() {
		return this.payToTime;
	}
	public void setPayToTime(Date payToTime) {
		this.payToTime = payToTime;
	}

	public String getPolicyNo() {
		return this.policyNo;
	}
	public void setPolicyNo(String policyNo) {
		this.policyNo = policyNo;
	}

	public Long getPremium() {
		return this.premium;
	}
	public void setPremium(Long premium) {
		this.premium = premium;
	}

	public String getProdName() {
		return this.prodName;
	}
	public void setProdName(String prodName) {
		this.prodName = prodName;
	}

	public String getSpNo() {
		return this.spNo;
	}
	public void setSpNo(String spNo) {
		this.spNo = spNo;
	}

	public Long getSumInsured() {
		return this.sumInsured;
	}
	public void setSumInsured(Long sumInsured) {
		this.sumInsured = sumInsured;
	}

	public Long getSurrenderFee() {
		return this.surrenderFee;
	}
	public void setSurrenderFee(Long surrenderFee) {
		this.surrenderFee = surrenderFee;
	}

	public Date getSurrenderTime() {
		return this.surrenderTime;
	}
	public void setSurrenderTime(Date surrenderTime) {
		this.surrenderTime = surrenderTime;
	}

}
