package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * InquiryOrderRequestVo
 *
 * @author auto create
 * @since 1.0, 2022-11-11 17:36:16
 */
public class InquiryOrderRequestVo extends AlipayObject {

	private static final long serialVersionUID = 1188814354522596312L;

	/**
	 * 合约计划开始生效时间
	 */
	@ApiField("contracteffectstartdate")
	private String contracteffectstartdate;

	/**
	 * 合约到期时间
	 */
	@ApiField("contractexpirydate")
	private String contractexpirydate;

	/**
	 * 定价因子
	 */
	@ApiField("elementmap")
	private Map elementmap;

	/**
	 * 商户id
	 */
	@ApiField("idyypevalue")
	private IdTypeValue idyypevalue;

	/**
	 * 机构id
	 */
	@ApiField("instid")
	private String instid;

	/**
	 * mcc
	 */
	@ApiField("mcc")
	private String mcc;

	/**
	 * 请求流水号
	 */
	@ApiField("outbizno")
	private String outbizno;

	/**
	 * 商户id
	 */
	@ApiListField("pids")
	@ApiField("string")
	private List<String> pids;

	/**
	 * pricerelkey
	 */
	@ApiField("pricerelkey")
	private String pricerelkey;

	/**
	 * 产品码
	 */
	@ApiField("productcode")
	private String productcode;

	/**
	 * 费率到期续期模式
	 */
	@ApiField("raterenewalmode")
	private String raterenewalmode;

	/**
	 * 价格保鲜模式
	 */
	@ApiField("refreshmode")
	private String refreshmode;

	/**
	 * 签名字段
	 */
	@ApiField("signstring")
	private String signstring;

	public String getContracteffectstartdate() {
		return this.contracteffectstartdate;
	}
	public void setContracteffectstartdate(String contracteffectstartdate) {
		this.contracteffectstartdate = contracteffectstartdate;
	}

	public String getContractexpirydate() {
		return this.contractexpirydate;
	}
	public void setContractexpirydate(String contractexpirydate) {
		this.contractexpirydate = contractexpirydate;
	}

	public Map getElementmap() {
		return this.elementmap;
	}
	public void setElementmap(Map elementmap) {
		this.elementmap = elementmap;
	}

	public IdTypeValue getIdyypevalue() {
		return this.idyypevalue;
	}
	public void setIdyypevalue(IdTypeValue idyypevalue) {
		this.idyypevalue = idyypevalue;
	}

	public String getInstid() {
		return this.instid;
	}
	public void setInstid(String instid) {
		this.instid = instid;
	}

	public String getMcc() {
		return this.mcc;
	}
	public void setMcc(String mcc) {
		this.mcc = mcc;
	}

	public String getOutbizno() {
		return this.outbizno;
	}
	public void setOutbizno(String outbizno) {
		this.outbizno = outbizno;
	}

	public List<String> getPids() {
		return this.pids;
	}
	public void setPids(List<String> pids) {
		this.pids = pids;
	}

	public String getPricerelkey() {
		return this.pricerelkey;
	}
	public void setPricerelkey(String pricerelkey) {
		this.pricerelkey = pricerelkey;
	}

	public String getProductcode() {
		return this.productcode;
	}
	public void setProductcode(String productcode) {
		this.productcode = productcode;
	}

	public String getRaterenewalmode() {
		return this.raterenewalmode;
	}
	public void setRaterenewalmode(String raterenewalmode) {
		this.raterenewalmode = raterenewalmode;
	}

	public String getRefreshmode() {
		return this.refreshmode;
	}
	public void setRefreshmode(String refreshmode) {
		this.refreshmode = refreshmode;
	}

	public String getSignstring() {
		return this.signstring;
	}
	public void setSignstring(String signstring) {
		this.signstring = signstring;
	}

}
