package com.alipay.api.domain;

import java.util.Date;
import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * Individual
 *
 * @author auto create
 * @since 1.0, 2022-03-31 10:58:28
 */
public class Individual extends AlipayObject {

	private static final long serialVersionUID = 8798882272331465336L;

	/**
	 * Attachments
	 */
	@ApiListField("attachments")
	@ApiField("ic_attachment")
	private List<IcAttachment> attachments;

	/**
	 * Date of birth,Timezone is set to UTC+0.
	 */
	@ApiField("birthdate")
	private String birthdate;

	/**
	 * 出生地址
	 */
	@ApiField("birthplace")
	private IcAddress birthplace;

	/**
	 * Certificates
	 */
	@ApiListField("certificates")
	@ApiField("ic_certificate")
	private List<IcCertificate> certificates;

	/**
	 * Contact address
	 */
	@ApiField("contactaddress")
	private IcAddress contactaddress;

	/**
	 * Contact methods
	 */
	@ApiListField("contactways")
	@ApiField("ic_contact_way")
	private List<IcContactWay> contactways;

	/**
	 * 所属部门
	 */
	@ApiField("department")
	private String department;

	/**
	 * 证件有效期
	 */
	@ApiField("expiredate")
	private Date expiredate;

	/**
	 * firstName
	 */
	@ApiField("firstname")
	private String firstname;

	/**
	 * FEMALE;MALE
	 */
	@ApiField("gender")
	private String gender;

	/**
	 * 个人身份注册号码，业务联系实体中不包含该字段
	 */
	@ApiField("idnumber")
	private String idnumber;

	/**
	 * ID_CARD；PASSPORT；BUSINESS_LICENSE；MAINLAND_TRAVEL_PERMIT_HK_MC；MAINLAND_TRAVEL_PERMIT_TAIWAN；ENTERPRISE_REGISTRATION；DRIVING_LICENSE；TAX_REGISTRATION_CERTIFICATE；BUSINESS_REGISTRATION；BANK_STATEMENT；MEDICAL_EXEMPTION；US_FEDERAL_EIN；OTHER_MATERIAL；
	 */
	@ApiField("idtype")
	private String idtype;

	/**
	 * lastName
	 */
	@ApiField("lastname")
	private String lastname;

	/**
	 * legalname
	 */
	@ApiField("legalname")
	private String legalname;

	/**
	 * nationality
	 */
	@ApiField("nationality")
	private String nationality;

	/**
	 * 职位
	 */
	@ApiField("position")
	private String position;

	/**
	 * 居住地址
	 */
	@ApiField("residentaddress")
	private IcAddress residentaddress;

	/**
	 * 税号
	 */
	@ApiField("taxno")
	private String taxno;

	/**
	 * 增值税税号
	 */
	@ApiField("vatno")
	private String vatno;

	/**
	 * WealthSource  财富来源
	 */
	@ApiListField("wealthsources")
	@ApiField("string")
	private List<String> wealthsources;

	public List<IcAttachment> getAttachments() {
		return this.attachments;
	}
	public void setAttachments(List<IcAttachment> attachments) {
		this.attachments = attachments;
	}

	public String getBirthdate() {
		return this.birthdate;
	}
	public void setBirthdate(String birthdate) {
		this.birthdate = birthdate;
	}

	public IcAddress getBirthplace() {
		return this.birthplace;
	}
	public void setBirthplace(IcAddress birthplace) {
		this.birthplace = birthplace;
	}

	public List<IcCertificate> getCertificates() {
		return this.certificates;
	}
	public void setCertificates(List<IcCertificate> certificates) {
		this.certificates = certificates;
	}

	public IcAddress getContactaddress() {
		return this.contactaddress;
	}
	public void setContactaddress(IcAddress contactaddress) {
		this.contactaddress = contactaddress;
	}

	public List<IcContactWay> getContactways() {
		return this.contactways;
	}
	public void setContactways(List<IcContactWay> contactways) {
		this.contactways = contactways;
	}

	public String getDepartment() {
		return this.department;
	}
	public void setDepartment(String department) {
		this.department = department;
	}

	public Date getExpiredate() {
		return this.expiredate;
	}
	public void setExpiredate(Date expiredate) {
		this.expiredate = expiredate;
	}

	public String getFirstname() {
		return this.firstname;
	}
	public void setFirstname(String firstname) {
		this.firstname = firstname;
	}

	public String getGender() {
		return this.gender;
	}
	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getIdnumber() {
		return this.idnumber;
	}
	public void setIdnumber(String idnumber) {
		this.idnumber = idnumber;
	}

	public String getIdtype() {
		return this.idtype;
	}
	public void setIdtype(String idtype) {
		this.idtype = idtype;
	}

	public String getLastname() {
		return this.lastname;
	}
	public void setLastname(String lastname) {
		this.lastname = lastname;
	}

	public String getLegalname() {
		return this.legalname;
	}
	public void setLegalname(String legalname) {
		this.legalname = legalname;
	}

	public String getNationality() {
		return this.nationality;
	}
	public void setNationality(String nationality) {
		this.nationality = nationality;
	}

	public String getPosition() {
		return this.position;
	}
	public void setPosition(String position) {
		this.position = position;
	}

	public IcAddress getResidentaddress() {
		return this.residentaddress;
	}
	public void setResidentaddress(IcAddress residentaddress) {
		this.residentaddress = residentaddress;
	}

	public String getTaxno() {
		return this.taxno;
	}
	public void setTaxno(String taxno) {
		this.taxno = taxno;
	}

	public String getVatno() {
		return this.vatno;
	}
	public void setVatno(String vatno) {
		this.vatno = vatno;
	}

	public List<String> getWealthsources() {
		return this.wealthsources;
	}
	public void setWealthsources(List<String> wealthsources) {
		this.wealthsources = wealthsources;
	}

}
