package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 用户信息
 *
 * @author auto create
 * @since 1.0, 2022-03-31 10:11:15
 */
public class IcUser extends AlipayObject {

	private static final long serialVersionUID = 4442713743955874727L;

	/**
	 * Date of birth Timezone is set to UTC+0.
	 */
	@ApiField("birthdate")
	private String birthdate;

	/**
	 * Certificate information
	 */
	@ApiField("certificate")
	private IcCertificate certificate;

	/**
	 * The two-character ISO 3166 country/region code
	 */
	@ApiField("nationality")
	private String nationality;

	/**
	 * AA
	 */
	@ApiField("useraddress")
	private IcAddress useraddress;

	/**
	 * User's email
	 */
	@ApiField("useremail")
	private String useremail;

	/**
	 * A unique identifier of the user. Required when transferFactor.transferFundType is FX_CNY or GLOBAL_CNH_CN.
	 */
	@ApiField("userid")
	private String userid;

	/**
	 * 全名
	 */
	@ApiField("username")
	private IcUserName username;

	/**
	 * AA
	 */
	@ApiField("userphoneno")
	private String userphoneno;

	public String getBirthdate() {
		return this.birthdate;
	}
	public void setBirthdate(String birthdate) {
		this.birthdate = birthdate;
	}

	public IcCertificate getCertificate() {
		return this.certificate;
	}
	public void setCertificate(IcCertificate certificate) {
		this.certificate = certificate;
	}

	public String getNationality() {
		return this.nationality;
	}
	public void setNationality(String nationality) {
		this.nationality = nationality;
	}

	public IcAddress getUseraddress() {
		return this.useraddress;
	}
	public void setUseraddress(IcAddress useraddress) {
		this.useraddress = useraddress;
	}

	public String getUseremail() {
		return this.useremail;
	}
	public void setUseremail(String useremail) {
		this.useremail = useremail;
	}

	public String getUserid() {
		return this.userid;
	}
	public void setUserid(String userid) {
		this.userid = userid;
	}

	public IcUserName getUsername() {
		return this.username;
	}
	public void setUsername(IcUserName username) {
		this.username = username;
	}

	public String getUserphoneno() {
		return this.userphoneno;
	}
	public void setUserphoneno(String userphoneno) {
		this.userphoneno = userphoneno;
	}

}
