package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * Certificate
 *
 * @author auto create
 * @since 1.0, 2022-03-31 10:00:48
 */
public class IcCertificate extends AlipayObject {

	private static final long serialVersionUID = 8788631554689817399L;

	/**
	 * Certificate number
	 */
	@ApiField("certificateno")
	private String certificateno;

	/**
	 * ID_CARD；PASSPORT；BUSINESS_LICENSE；MAINLAND_TRAVEL_PERMIT_HK_MC；MAINLAND_TRAVEL_PERMIT_TAIWAN；ENTERPRISE_REGISTRATION；DRIVING_LICENSE；TAX_REGISTRATION_CERTIFICATE；BUSINESS_REGISTRATION；BANK_STATEMENT；MEDICAL_EXEMPTION；US_FEDERAL_EIN；OTHER_MATERIAL
	 */
	@ApiField("certificatetype")
	private String certificatetype;

	/**
	 * Certificate effective date,Timezone is set to UTC+0.
	 */
	@ApiField("effectivedate")
	private String effectivedate;

	/**
	 * Certificate expiry date,Timezone is set to UTC+0.
	 */
	@ApiField("expiredate")
	private String expiredate;

	/**
	 * 证件附件信息
	 */
	@ApiListField("files")
	@ApiField("string")
	private List<String> files;

	/**
	 * Certificate holder name
	 */
	@ApiField("holdername")
	private IcUserName holdername;

	public String getCertificateno() {
		return this.certificateno;
	}
	public void setCertificateno(String certificateno) {
		this.certificateno = certificateno;
	}

	public String getCertificatetype() {
		return this.certificatetype;
	}
	public void setCertificatetype(String certificatetype) {
		this.certificatetype = certificatetype;
	}

	public String getEffectivedate() {
		return this.effectivedate;
	}
	public void setEffectivedate(String effectivedate) {
		this.effectivedate = effectivedate;
	}

	public String getExpiredate() {
		return this.expiredate;
	}
	public void setExpiredate(String expiredate) {
		this.expiredate = expiredate;
	}

	public List<String> getFiles() {
		return this.files;
	}
	public void setFiles(List<String> files) {
		this.files = files;
	}

	public IcUserName getHoldername() {
		return this.holdername;
	}
	public void setHoldername(IcUserName holdername) {
		this.holdername = holdername;
	}

}
