package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * InquiryCustomer  BusinessPartner
 *
 * @author auto create
 * @since 1.0, 2022-04-01 14:50:04
 */
public class IcBusinessPartner extends AlipayObject {

	private static final long serialVersionUID = 6262395957157156833L;

	/**
	 * 商业品牌
	 */
	@ApiField("brand")
	private String brand;

	/**
	 * Business contact entities
	 */
	@ApiListField("businesscontactentities")
	@ApiField("business_contact_entity")
	private List<BusinessContactEntity> businesscontactentities;

	/**
	 * Business name
	 */
	@ApiField("businessname")
	private String businessname;

	/**
	 * 资金去向
	 */
	@ApiListField("fundsdestinations")
	@ApiField("string")
	private List<String> fundsdestinations;

	/**
	 * FundsSource资金来源
	 */
	@ApiListField("fundssources")
	@ApiField("string")
	private List<String> fundssources;

	/**
	 * 公司行业
	 */
	@ApiField("industrytype")
	private String industrytype;

	/**
	 * 商业logo
@Deprecated 商业logo 存attach,目前收单链路已集成attach里面的logo
	 */
	@ApiField("logo")
	private String logo;

	/**
	 * 主营商品
	 */
	@ApiListField("maingoods")
	@ApiField("string")
	private List<String> maingoods;

	/**
	 * The merchant category code
	 */
	@ApiField("mcc")
	private String mcc;

	/**
	 * 运营的详细地址
	 */
	@ApiField("operationaddress")
	private IcAddress operationaddress;

	/**
	 * 企业开户目的
	 */
	@ApiListField("registrationpurpose")
	@ApiField("string")
	private List<String> registrationpurpose;

	/**
	 * 店铺集合
	 */
	@ApiListField("stores")
	@ApiField("store")
	private List<Store> stores;

	/**
	 * AAA
	 */
	@ApiListField("websites")
	@ApiField("website")
	private List<Website> websites;

	public String getBrand() {
		return this.brand;
	}
	public void setBrand(String brand) {
		this.brand = brand;
	}

	public List<BusinessContactEntity> getBusinesscontactentities() {
		return this.businesscontactentities;
	}
	public void setBusinesscontactentities(List<BusinessContactEntity> businesscontactentities) {
		this.businesscontactentities = businesscontactentities;
	}

	public String getBusinessname() {
		return this.businessname;
	}
	public void setBusinessname(String businessname) {
		this.businessname = businessname;
	}

	public List<String> getFundsdestinations() {
		return this.fundsdestinations;
	}
	public void setFundsdestinations(List<String> fundsdestinations) {
		this.fundsdestinations = fundsdestinations;
	}

	public List<String> getFundssources() {
		return this.fundssources;
	}
	public void setFundssources(List<String> fundssources) {
		this.fundssources = fundssources;
	}

	public String getIndustrytype() {
		return this.industrytype;
	}
	public void setIndustrytype(String industrytype) {
		this.industrytype = industrytype;
	}

	public String getLogo() {
		return this.logo;
	}
	public void setLogo(String logo) {
		this.logo = logo;
	}

	public List<String> getMaingoods() {
		return this.maingoods;
	}
	public void setMaingoods(List<String> maingoods) {
		this.maingoods = maingoods;
	}

	public String getMcc() {
		return this.mcc;
	}
	public void setMcc(String mcc) {
		this.mcc = mcc;
	}

	public IcAddress getOperationaddress() {
		return this.operationaddress;
	}
	public void setOperationaddress(IcAddress operationaddress) {
		this.operationaddress = operationaddress;
	}

	public List<String> getRegistrationpurpose() {
		return this.registrationpurpose;
	}
	public void setRegistrationpurpose(List<String> registrationpurpose) {
		this.registrationpurpose = registrationpurpose;
	}

	public List<Store> getStores() {
		return this.stores;
	}
	public void setStores(List<Store> stores) {
		this.stores = stores;
	}

	public List<Website> getWebsites() {
		return this.websites;
	}
	public void setWebsites(List<Website> websites) {
		this.websites = websites;
	}

}
