package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 地址
 *
 * @author auto create
 * @since 1.0, 2022-03-30 17:00:45
 */
public class IcAddress extends AlipayObject {

	private static final long serialVersionUID = 4848212754628827111L;

	/**
	 * Address line 1 (such as street, PO Box, or company name)
	 */
	@ApiField("addressone")
	private String addressone;

	/**
	 * Address line 2 (such as apartment, suite, unit, or building)
	 */
	@ApiField("addresstwo")
	private String addresstwo;

	/**
	 * City, district, suburb, town, or village
	 */
	@ApiField("city")
	private String city;

	/**
	 * Two-character ISO 3166 country/region code
	 */
	@ApiField("region")
	private String region;

	/**
	 * State, country, or province
	 */
	@ApiField("state")
	private String state;

	/**
	 * ZIP or postal code
	 */
	@ApiField("zipcode")
	private String zipcode;

	public String getAddressone() {
		return this.addressone;
	}
	public void setAddressone(String addressone) {
		this.addressone = addressone;
	}

	public String getAddresstwo() {
		return this.addresstwo;
	}
	public void setAddresstwo(String addresstwo) {
		this.addresstwo = addresstwo;
	}

	public String getCity() {
		return this.city;
	}
	public void setCity(String city) {
		this.city = city;
	}

	public String getRegion() {
		return this.region;
	}
	public void setRegion(String region) {
		this.region = region;
	}

	public String getState() {
		return this.state;
	}
	public void setState(String state) {
		this.state = state;
	}

	public String getZipcode() {
		return this.zipcode;
	}
	public void setZipcode(String zipcode) {
		this.zipcode = zipcode;
	}

}
