package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 流程基本信息
 *
 * @author auto create
 * @since 1.0, 2021-09-27 19:50:54
 */
public class FlowBaseInfoVo extends AlipayObject {

	private static final long serialVersionUID = 8835876411298819175L;

	/**
	 * 128
	 */
	@ApiField("channel")
	private String channel;

	/**
	 * 当前流程所在节点
	 */
	@ApiField("current_node")
	private String currentNode;

	/**
	 * 失败原因（currentNode为fail才可能会有）
	 */
	@ApiField("fail_reason")
	private String failReason;

	/**
	 * 当前流程所在节点的状态
	 */
	@ApiField("flow_status")
	private String flowStatus;

	/**
	 * 流程类型
	 */
	@ApiField("flow_type")
	private String flowType;

	/**
	 * 流程id
	 */
	@ApiField("id")
	private String id;

	/**
	 * 网商角色id
	 */
	@ApiField("ip_role_id")
	private String ipRoleId;

	/**
	 * 创建流程的支付宝ID
	 */
	@ApiField("operator_alipay_uid")
	private String operatorAlipayUid;

	/**
	 * 操作员角色id
	 */
	@ApiField("operator_role_id")
	private String operatorRoleId;

	/**
	 * 支付宝uid
	 */
	@ApiField("out_channel_id")
	private String outChannelId;

	/**
	 * 对外的流程状态code
	 */
	@ApiField("out_status_code")
	private String outStatusCode;

	/**
	 * 对外流程状态描述
	 */
	@ApiField("out_status_desc")
	private String outStatusDesc;

	/**
	 * 产品码
	 */
	@ApiField("pcode")
	private String pcode;

	/**
	 * 解决方案(currentNode为fail才可能会有）
	 */
	@ApiField("solution")
	private String solution;

	public String getChannel() {
		return this.channel;
	}
	public void setChannel(String channel) {
		this.channel = channel;
	}

	public String getCurrentNode() {
		return this.currentNode;
	}
	public void setCurrentNode(String currentNode) {
		this.currentNode = currentNode;
	}

	public String getFailReason() {
		return this.failReason;
	}
	public void setFailReason(String failReason) {
		this.failReason = failReason;
	}

	public String getFlowStatus() {
		return this.flowStatus;
	}
	public void setFlowStatus(String flowStatus) {
		this.flowStatus = flowStatus;
	}

	public String getFlowType() {
		return this.flowType;
	}
	public void setFlowType(String flowType) {
		this.flowType = flowType;
	}

	public String getId() {
		return this.id;
	}
	public void setId(String id) {
		this.id = id;
	}

	public String getIpRoleId() {
		return this.ipRoleId;
	}
	public void setIpRoleId(String ipRoleId) {
		this.ipRoleId = ipRoleId;
	}

	public String getOperatorAlipayUid() {
		return this.operatorAlipayUid;
	}
	public void setOperatorAlipayUid(String operatorAlipayUid) {
		this.operatorAlipayUid = operatorAlipayUid;
	}

	public String getOperatorRoleId() {
		return this.operatorRoleId;
	}
	public void setOperatorRoleId(String operatorRoleId) {
		this.operatorRoleId = operatorRoleId;
	}

	public String getOutChannelId() {
		return this.outChannelId;
	}
	public void setOutChannelId(String outChannelId) {
		this.outChannelId = outChannelId;
	}

	public String getOutStatusCode() {
		return this.outStatusCode;
	}
	public void setOutStatusCode(String outStatusCode) {
		this.outStatusCode = outStatusCode;
	}

	public String getOutStatusDesc() {
		return this.outStatusDesc;
	}
	public void setOutStatusDesc(String outStatusDesc) {
		this.outStatusDesc = outStatusDesc;
	}

	public String getPcode() {
		return this.pcode;
	}
	public void setPcode(String pcode) {
		this.pcode = pcode;
	}

	public String getSolution() {
		return this.solution;
	}
	public void setSolution(String solution) {
		this.solution = solution;
	}

}
