package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 费率组信息
 *
 * @author auto create
 * @since 1.0, 2022-11-12 16:04:28
 */
public class FeeInfoVO extends AlipayObject {

	private static final long serialVersionUID = 6447423587151948427L;

	/**
	 * 进位规则
	 */
	@ApiField("carryrule")
	private PriceComponentVO carryrule;

	/**
	 * 计算方式
	 */
	@ApiField("clctype")
	private PriceComponentVO clctype;

	/**
	 * 费率约束
	 */
	@ApiListField("feeconstraintlist")
	@ApiField("price_condition_info_v_o")
	private List<PriceConditionInfoVO> feeconstraintlist;

	/**
	 * 费率组编号code，带前缀
	 */
	@ApiField("feeinfocode")
	private String feeinfocode;

	/**
	 * 费率组id
	 */
	@ApiField("feeinfoid")
	private Long feeinfoid;

	/**
	 * 费率类型
	 */
	@ApiField("feeinfotype")
	private String feeinfotype;

	/**
	 * 费率
	 */
	@ApiListField("feerange")
	@ApiField("fee_range_v_o")
	private List<FeeRangeVO> feerange;

	/**
	 * 计费公式
	 */
	@ApiField("formulacode")
	private PriceComponentVO formulacode;

	/**
	 * 是否区间费率
	 */
	@ApiField("intervalrate")
	private Boolean intervalrate;

	/**
	 * 阶梯累量依据
	 */
	@ApiField("loadbasis")
	private PriceComponentVO loadbasis;

	/**
	 * 计费依据
	 */
	@ApiField("measurementbasis")
	private PriceComponentVO measurementbasis;

	/**
	 * 费率模式
	 */
	@ApiField("ratepattern")
	private PriceComponentVO ratepattern;

	/**
	 * 费率单位
	 */
	@ApiField("rateunit")
	private String rateunit;

	/**
	 * 累量规则
	 */
	@ApiField("tiredrule")
	private PriceComponentVO tiredrule;

	public PriceComponentVO getCarryrule() {
		return this.carryrule;
	}
	public void setCarryrule(PriceComponentVO carryrule) {
		this.carryrule = carryrule;
	}

	public PriceComponentVO getClctype() {
		return this.clctype;
	}
	public void setClctype(PriceComponentVO clctype) {
		this.clctype = clctype;
	}

	public List<PriceConditionInfoVO> getFeeconstraintlist() {
		return this.feeconstraintlist;
	}
	public void setFeeconstraintlist(List<PriceConditionInfoVO> feeconstraintlist) {
		this.feeconstraintlist = feeconstraintlist;
	}

	public String getFeeinfocode() {
		return this.feeinfocode;
	}
	public void setFeeinfocode(String feeinfocode) {
		this.feeinfocode = feeinfocode;
	}

	public Long getFeeinfoid() {
		return this.feeinfoid;
	}
	public void setFeeinfoid(Long feeinfoid) {
		this.feeinfoid = feeinfoid;
	}

	public String getFeeinfotype() {
		return this.feeinfotype;
	}
	public void setFeeinfotype(String feeinfotype) {
		this.feeinfotype = feeinfotype;
	}

	public List<FeeRangeVO> getFeerange() {
		return this.feerange;
	}
	public void setFeerange(List<FeeRangeVO> feerange) {
		this.feerange = feerange;
	}

	public PriceComponentVO getFormulacode() {
		return this.formulacode;
	}
	public void setFormulacode(PriceComponentVO formulacode) {
		this.formulacode = formulacode;
	}

	public Boolean getIntervalrate() {
		return this.intervalrate;
	}
	public void setIntervalrate(Boolean intervalrate) {
		this.intervalrate = intervalrate;
	}

	public PriceComponentVO getLoadbasis() {
		return this.loadbasis;
	}
	public void setLoadbasis(PriceComponentVO loadbasis) {
		this.loadbasis = loadbasis;
	}

	public PriceComponentVO getMeasurementbasis() {
		return this.measurementbasis;
	}
	public void setMeasurementbasis(PriceComponentVO measurementbasis) {
		this.measurementbasis = measurementbasis;
	}

	public PriceComponentVO getRatepattern() {
		return this.ratepattern;
	}
	public void setRatepattern(PriceComponentVO ratepattern) {
		this.ratepattern = ratepattern;
	}

	public String getRateunit() {
		return this.rateunit;
	}
	public void setRateunit(String rateunit) {
		this.rateunit = rateunit;
	}

	public PriceComponentVO getTiredrule() {
		return this.tiredrule;
	}
	public void setTiredrule(PriceComponentVO tiredrule) {
		this.tiredrule = tiredrule;
	}

}
