package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 屏幕设备信息
 *
 * @author auto create
 * @since 1.0, 2021-05-19 17:11:21
 */
public class DeviceInstance extends AlipayObject {

	private static final long serialVersionUID = 5742113345932167476L;

	/**
	 * device_model 设备型号，如商业显示、盒子<CMS010>
	 */
	@ApiField("device_model")
	private String deviceModel;

	/**
	 * device_sn 设备sn，由安装人员现场录入
	 */
	@ApiField("device_sn")
	private String deviceSn;

	/**
	 * 设备子型号，由订单获取SCREEN_27，SCREEN_32
	 */
	@ApiField("device_sub_model")
	private String deviceSubModel;

	public String getDeviceModel() {
		return this.deviceModel;
	}
	public void setDeviceModel(String deviceModel) {
		this.deviceModel = deviceModel;
	}

	public String getDeviceSn() {
		return this.deviceSn;
	}
	public void setDeviceSn(String deviceSn) {
		this.deviceSn = deviceSn;
	}

	public String getDeviceSubModel() {
		return this.deviceSubModel;
	}
	public void setDeviceSubModel(String deviceSubModel) {
		this.deviceSubModel = deviceSubModel;
	}

}
